/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.zookeeper.NeoStoreUtil;

public class StartHaDb {
    public static final File PATH = new File("var/hadb");
    static final String ME = "172.16.1.242:5559";
    static final int MY_MACHINE_ID = 2;
    static final String[] ZOO_KEEPER_SERVERS = new String[]{"172.16.2.33:2181", "172.16.1.242:2181", "172.16.4.14:2181"};

    public static void main(String[] args) throws Exception {
        NeoStoreUtil store = new NeoStoreUtil(PATH.getPath());
        System.out.println("Starting store: createTime=" + new Date(store.getCreationTime()) + " identifier=" + store.getStoreId() + " last committed tx=" + store.getLastCommittedTx());
        GraphDatabaseService db = StartHaDb.startDb();
        System.out.println("Waiting for ENTER (for clean shutdown)");
        System.in.read();
        db.shutdown();
    }

    private static GraphDatabaseService startDb() throws IOException {
        return new HighlyAvailableGraphDatabase(PATH.getPath(), MapUtil.stringMap((String[])new String[]{"ha.server_id", "2", "ha.coordinators", StartHaDb.join(ZOO_KEEPER_SERVERS, ","), "ha.server", ME, "enable_remote_shell", "true", "keep_logical_logs", "true"}));
    }

    public static String join(String[] strings, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            builder.append((builder.length() > 0 ? delimiter : "") + string);
        }
        return builder.toString();
    }
}

