/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.netty.channel.Channel;
import org.neo4j.com.RequestType;
import org.neo4j.com.Server;
import org.neo4j.com.SlaveContext;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.MasterImpl;

public class MasterServer
extends Server<Master, Void> {
    static final byte PROTOCOL_VERSION = 1;
    static final int FRAME_LENGTH = 0x1000000;

    public MasterServer(Master realMaster, int port, String storeDir) {
        super((Object)realMaster, port, storeDir, 0x1000000, (byte)1);
    }

    protected RequestType<Master> getRequestContext(byte id) {
        return MasterClient.HaRequestType.values()[id];
    }

    protected void finishOffChannel(Channel channel, SlaveContext context) {
        ((Master)this.getMaster()).finishTransaction(context, false);
    }

    public void shutdown() {
        super.shutdown();
        ((Master)this.getMaster()).shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Collection<SlaveContext>> getSlaveInformation() {
        Map channels;
        HashSet<Integer> machineIds = new HashSet<Integer>();
        Map map = channels = this.getConnectedSlaveChannels();
        synchronized (map) {
            for (SlaveContext context : channels.values()) {
                machineIds.add(context.machineId());
            }
        }
        Map<Integer, Collection<SlaveContext>> ongoingTransactions = ((MasterImpl)this.getMaster()).getOngoingTransactions();
        for (Integer machineId : machineIds) {
            if (ongoingTransactions.containsKey(machineId)) continue;
            ongoingTransactions.put(machineId, Collections.emptyList());
        }
        return new TreeMap<Integer, Collection<SlaveContext>>(ongoingTransactions);
    }
}

