/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.util.ArrayList;
import java.util.Map;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.ha.ClusterClient;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.zookeeper.AbstractZooKeeperManager;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperMachine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;

public class ZooKeeperClusterClient
extends AbstractZooKeeperManager
implements ClusterClient {
    private final ZooKeeper zooKeeper;
    private String rootPath;
    private Watcher.Event.KeeperState state = Watcher.Event.KeeperState.Disconnected;
    private final String clusterName;

    public ZooKeeperClusterClient(String zooKeeperServers) {
        this(zooKeeperServers, "neo4j.ha", null, 5000L);
    }

    public ZooKeeperClusterClient(String zooKeeperServers, AbstractGraphDatabase db) {
        this(zooKeeperServers, "neo4j.ha", db, 5000L);
    }

    public ZooKeeperClusterClient(String zooKeeperServers, String clusterName) {
        this(zooKeeperServers, clusterName, null, 5000L);
    }

    public ZooKeeperClusterClient(String zooKeeperServers, String clusterName, AbstractGraphDatabase db, long sessionTimeout) {
        super(zooKeeperServers, db, 20, 20, 20, sessionTimeout);
        this.clusterName = clusterName;
        this.zooKeeper = this.instantiateZooKeeper();
    }

    @Override
    protected int getMyMachineId() {
        throw new UnsupportedOperationException("Not implemented ClusterManager.getMyMachineId()");
    }

    @Override
    public void waitForSyncConnected() {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)this.getSessionTimeout() && this.state != Watcher.Event.KeeperState.SyncConnected) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    @Override
    public int getBackupPort(int machineId) {
        int port = (Integer)this.readHaServer(machineId, true).other();
        return port != 0 ? port : 6362;
    }

    public void process(WatchedEvent event) {
        String path = event.getPath();
        if (path == null) {
            this.state = event.getState();
        }
    }

    @Override
    public Machine getMaster() {
        if (this.readRootPath() == null) {
            return null;
        }
        return this.getMasterBasedOn(this.getAllMachines(true).values());
    }

    @Override
    public Pair<Master, Machine> getMasterClient() {
        Machine masterMachine = this.getMaster();
        if (masterMachine == null) {
            return null;
        }
        Master masterClient = this.getMasterClientToMachine(masterMachine);
        return Pair.of((Object)masterClient, (Object)masterMachine);
    }

    @Override
    public String getRoot() {
        if (this.rootPath == null) {
            this.rootPath = this.readRootPath();
        }
        return this.rootPath;
    }

    private String readRootPath() {
        this.waitForSyncConnected();
        StoreId storeId = ZooKeeperClusterClient.getClusterStoreId(this.zooKeeper, this.clusterName);
        if (storeId == null) {
            return null;
        }
        return ZooKeeperClusterClient.asRootPath(storeId);
    }

    public static String asRootPath(StoreId storeId) {
        return "/" + storeId.getCreationTime() + "_" + storeId.getRandomId();
    }

    public static StoreId getClusterStoreId(ZooKeeper keeper, String clusterName) {
        try {
            byte[] child = keeper.getData("/" + clusterName, false, null);
            return StoreId.deserialize((byte[])child);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE) {
                return null;
            }
            throw new ZooKeeperException("Error getting store id", e);
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    @Override
    public Machine[] getConnectedSlaves() {
        Map<Integer, ZooKeeperMachine> machines = this.getAllMachines(true);
        ZooKeeperMachine master = this.getMasterBasedOn(machines.values());
        ArrayList<ZooKeeperMachine> result = new ArrayList<ZooKeeperMachine>(machines.values());
        result.remove(master);
        return result.toArray(new Machine[result.size()]);
    }

    @Override
    public ZooKeeper getZooKeeper(boolean sync) {
        if (sync) {
            this.zooKeeper.sync(this.getRoot(), null, null);
        }
        return this.zooKeeper;
    }
}

