/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.HAGraphDb;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.BrokerFactory;
import org.neo4j.kernel.ha.ClusterClient;
import org.neo4j.kernel.ha.FakeClusterClient;
import org.neo4j.kernel.ha.FakeMasterBroker;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.TargetDirectory;
import slavetest.PlaceHolderGraphDatabaseService;

public class TestBranchedData {
    private final File dir = TargetDirectory.forTest(this.getClass()).graphDbDir(true);

    @Test
    public void migrationOfBranchedDataDirectories() throws Exception {
        long[] timestamps = new long[3];
        for (int i = 0; i < timestamps.length; ++i) {
            this.startDbAndCreateNode();
            timestamps[i] = this.moveAwayToLookLikeOldBranchedDirectory();
            Thread.sleep(1L);
        }
        final PlaceHolderGraphDatabaseService placeHolderDb = new PlaceHolderGraphDatabaseService(this.dir.getAbsolutePath());
        FakeMasterBroker broker = new FakeMasterBroker(1, placeHolderDb, MapUtil.stringMap((String[])new String[0]));
        HAGraphDb db = new HAGraphDb(this.dir.getAbsolutePath(), MapUtil.stringMap((String[])new String[]{"ha.server_id", "1"}), new BrokerFactory((Broker)broker){
            final /* synthetic */ Broker val$broker;
            {
                this.val$broker = broker;
            }

            public Broker create(AbstractGraphDatabase graphDb, Map<String, String> graphDbConfig) {
                placeHolderDb.setDb((GraphDatabaseService)graphDb);
                return this.val$broker;
            }
        }, (ClusterClient)new FakeClusterClient((Broker)broker));
        db.shutdown();
        for (long timestamp : timestamps) {
            Assert.assertFalse((boolean)new File(this.dir, "branched-" + timestamp).exists());
            Assert.assertTrue((boolean)HAGraphDb.BranchedDataPolicy.getBranchedDataDirectory((String)this.dir.getAbsolutePath(), (long)timestamp).exists());
        }
    }

    private long moveAwayToLookLikeOldBranchedDirectory() {
        long timestamp = System.currentTimeMillis();
        File branchDir = new File(this.dir, "branched-" + System.currentTimeMillis());
        branchDir.mkdirs();
        for (File file : this.dir.listFiles()) {
            if (file.equals("messages.log") || file.getName().startsWith("branched-")) continue;
            Assert.assertTrue((boolean)FileUtils.renameFile((File)file, (File)new File(branchDir, file.getName())));
        }
        return timestamp;
    }

    private void startDbAndCreateNode() {
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(this.dir.getAbsolutePath());
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        db.shutdown();
    }
}

