/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HAGraphDb;
import org.neo4j.kernel.ha.zookeeper.NoMasterException;
import org.neo4j.kernel.ha.zookeeper.ZooClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperBroker;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestConfig {
    private LocalhostZooKeeperCluster zoo;
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @Before
    public void doBefore() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.standardZoo(this.getClass());
    }

    @After
    public void doAfter() throws Exception {
        this.zoo.shutdown();
    }

    @Test
    public void testZkSessionTimeout() throws Exception {
        long timeout = 80000L;
        HAGraphDb db = new HAGraphDb(this.dir.directory("zkTimeout", true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{"ha.server_id", "1", "ha.coordinators", this.zoo.getConnectionString(), "ha.zk_session_timeout", timeout + "ms"}));
        ZooKeeperBroker broker = (ZooKeeperBroker)db.getBroker();
        Field f = broker.getClass().getDeclaredField("zooClient");
        f.setAccessible(true);
        ZooClient zooClient = (ZooClient)f.get(broker);
        Method m = zooClient.getClass().getSuperclass().getDeclaredMethod("getSessionTimeout", new Class[0]);
        m.setAccessible(true);
        Integer timeoutParsed = (Integer)m.invoke((Object)zooClient, new Object[0]);
        Assert.assertEquals((long)timeout, (long)timeoutParsed.intValue());
        f = db.getClass().getDeclaredField("clusterClient");
        f.setAccessible(true);
        ZooKeeperClusterClient clusterClient = (ZooKeeperClusterClient)f.get(db);
        m = clusterClient.getClass().getSuperclass().getDeclaredMethod("getSessionTimeout", new Class[0]);
        m.setAccessible(true);
        timeoutParsed = (Integer)m.invoke((Object)clusterClient, new Object[0]);
        Assert.assertEquals((long)timeout, (long)timeoutParsed.intValue());
        db.shutdown();
    }

    @Test
    public void gcrCachesGetsReusedBetweenInternalRestarts() throws Exception {
        ArrayList<HAGraphDb> dbs = new ArrayList<HAGraphDb>();
        for (int i = 0; i < 3; ++i) {
            Map config = MapUtil.stringMap((String[])new String[]{"ha.server_id", "" + i, "ha.coordinators", this.zoo.getConnectionString(), "cache_type", "gcr"});
            HAGraphDb db = new HAGraphDb(this.dir.directory("gcr" + i, true).getAbsolutePath(), config);
            dbs.add(db);
        }
        this.doTransaction((HAGraphDb)dbs.get(0));
        int master = this.getMaster(dbs);
        Map<Integer, Cache<?>> cacheObjects = this.gatherCacheObjects(dbs);
        ((HAGraphDb)dbs.get(master)).shutdown();
        int otherThanMaster = (master + 1) % dbs.size();
        this.pullUpdates((HAGraphDb)dbs.get(otherThanMaster));
        int newMaster = this.getMaster(dbs);
        Assert.assertFalse((master == newMaster ? 1 : 0) != 0);
        Cache newCache = (Cache)IteratorUtil.first((Iterable)((HAGraphDb)dbs.get(newMaster)).getConfig().getGraphDbModule().getNodeManager().caches());
        Assert.assertEquals((String)"Expected the cache instance from when it was slave and now when it's master to be the same", cacheObjects.get(newMaster), (Object)newCache);
        for (int i = 0; i < dbs.size(); ++i) {
            if (i == master) continue;
            ((HAGraphDb)dbs.get(i)).shutdown();
        }
    }

    private void pullUpdates(HAGraphDb db) {
        try {
            db.pullUpdates();
        }
        catch (NoMasterException e) {
            db.pullUpdates();
        }
    }

    private Map<Integer, Cache<?>> gatherCacheObjects(List<HAGraphDb> dbs) {
        HashMap map = new HashMap();
        for (int i = 0; i < dbs.size(); ++i) {
            map.put(i, (Cache<?>)IteratorUtil.first((Iterable)dbs.get(i).getConfig().getGraphDbModule().getNodeManager().caches()));
        }
        return map;
    }

    private int getMaster(List<HAGraphDb> dbs) {
        for (int i = 0; i < dbs.size(); ++i) {
            HAGraphDb db = dbs.get(i);
            if (!db.isMaster()) continue;
            return i;
        }
        throw new IllegalStateException("No master found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransaction(HAGraphDb db) {
        Transaction tx = db.beginTx();
        try {
            db.createNode();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

