/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import org.neo4j.backup.OnlineBackupExtension;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.HAGraphDb;
import org.neo4j.kernel.ha.AsyncZooKeeperLastCommittedTxIdSetter;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.TimeUtil;
import org.neo4j.kernel.ha.ZooKeeperLastCommittedTxIdSetter;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;

public class HaConfig {
    public static final String CONFIG_KEY_OLD_SERVER_ID = "ha.machine_id";
    public static final String CONFIG_KEY_SERVER_ID = "ha.server_id";
    public static final String CONFIG_KEY_OLD_COORDINATORS = "ha.zoo_keeper_servers";
    public static final String CONFIG_KEY_COORDINATORS = "ha.coordinators";
    public static final String CONFIG_KEY_SERVER = "ha.server";
    public static final String CONFIG_KEY_CLUSTER_NAME = "ha.cluster_name";
    public static final String CONFIG_KEY_PULL_INTERVAL = "ha.pull_interval";
    public static final String CONFIG_KEY_ALLOW_INIT_CLUSTER = "ha.allow_init_cluster";
    public static final String CONFIG_KEY_MAX_CONCURRENT_CHANNELS_PER_SLAVE = "ha.max_concurrent_channels_per_slave";
    public static final String CONFIG_KEY_BRANCHED_DATA_POLICY = "ha.branched_data_policy";
    public static final String CONFIG_KEY_READ_TIMEOUT = "ha.read_timeout";
    public static final String CONFIG_KEY_SLAVE_COORDINATOR_UPDATE_MODE = "ha.slave_coordinator_update_mode";
    public static final String CONFIG_KEY_LOCK_READ_TIMEOUT = "ha.lock_read_timeout";
    public static final String CONFIG_KEY_COORDINATOR_FETCH_INFO_TIMEOUT = "ha.coordinator_fetch_info_timeout";
    public static final String CONFIG_KEY_MAX_CONCURRENT_TRANSACTIONS_ON_MASTER = "ha.max_concurrent_transactions_on_master";
    public static final String CONFIG_KEY_ZK_SESSION_TIMEOUT = "ha.zk_session_timeout";
    public static final String CONFIG_DEFAULT_HA_CLUSTER_NAME = "neo4j.ha";
    public static final int CONFIG_DEFAULT_PORT = 6361;
    public static final long CONFIG_DEFAULT_PULL_INTERVAL = -1L;
    public static final int CONFIG_DEFAULT_COORDINATOR_FETCH_INFO_TIMEOUT = 500;
    public static final long CONFIG_DEFAULT_ZK_SESSION_TIMEOUT = 5000L;
    @Documented(value=" The amount of memory to use for the node cache (when using the 'gcr'\n cache).\n")
    public static final String NODE_CACHE_SIZE = "node_cache_size";
    @Documented(value=" The amount of memory to use for the relationship cache (when using the\n 'gcr' cache).\n")
    public static final String RELATIONSHIP_CACHE_SIZE = "relationship_cache_size";
    @Documented(value=" The fraction of the heap (1%-10%) to use for the base array in the node\n cache (when using the 'gcr' cache).\n")
    public static final String NODE_CACHE_ARRAY_FRACTION = "node_cache_array_fraction";
    @Documented(value=" The fraction of the heap (1%-10%) to use for the base array in the\n relationship cache (when using the 'gcr' cache).\n")
    public static final String RELATIONSHIP_CACHE_ARRAY_FRACTION = "relationship_cache_array_fraction";
    @Documented(value=" The minimal time that must pass in between logging statistics from the\n cache (when using the 'gcr' cache).\n Default unit is seconds, suffix with 's', 'm', or 'ms' to have the unit\n be seconds, minutes or milliseconds respectively.\n")
    public static final String GCR_CACHE_MIN_LOG_INTERVAL = "gcr_cache_min_log_interval";

    public static String getConfigValue(Map<String, String> config, String ... oneKeyOutOf) {
        String firstFound = null;
        int foundIndex = -1;
        for (int i = 0; i < oneKeyOutOf.length; ++i) {
            String toTry = oneKeyOutOf[i];
            String value = config.get(toTry);
            if (value == null) continue;
            if (firstFound != null) {
                throw new RuntimeException("Multiple configuration values set for the same logical key: " + Arrays.asList(oneKeyOutOf));
            }
            firstFound = value;
            foundIndex = i;
        }
        if (firstFound == null) {
            throw new RuntimeException("No configuration set for any of: " + Arrays.asList(oneKeyOutOf));
        }
        if (foundIndex > 0) {
            System.err.println("Deprecated configuration key '" + oneKeyOutOf[foundIndex] + "' used instead of the preferred '" + oneKeyOutOf[0] + "'");
        }
        return firstFound;
    }

    public static HAGraphDb.BranchedDataPolicy getBranchedDataPolicyFromConfig(Map<String, String> config) {
        return config.containsKey(CONFIG_KEY_BRANCHED_DATA_POLICY) ? HAGraphDb.BranchedDataPolicy.valueOf(config.get(CONFIG_KEY_BRANCHED_DATA_POLICY)) : HAGraphDb.BranchedDataPolicy.keep_all;
    }

    public static SlaveUpdateMode getSlaveUpdateModeFromConfig(Map<String, String> config) {
        return config.containsKey(CONFIG_KEY_SLAVE_COORDINATOR_UPDATE_MODE) ? SlaveUpdateMode.valueOf(config.get(CONFIG_KEY_SLAVE_COORDINATOR_UPDATE_MODE)) : SlaveUpdateMode.async;
    }

    public static int getClientReadTimeoutFromConfig(Map<String, String> config) {
        String value = config.get(CONFIG_KEY_READ_TIMEOUT);
        return value != null ? Integer.parseInt(value) : 20;
    }

    public static int getClientLockReadTimeoutFromConfig(Map<String, String> config) {
        String value = config.get(CONFIG_KEY_LOCK_READ_TIMEOUT);
        return value != null ? Integer.parseInt(value) : HaConfig.getClientReadTimeoutFromConfig(config);
    }

    public static int getMaxConcurrentChannelsPerSlaveFromConfig(Map<String, String> config) {
        String value = config.get(CONFIG_KEY_MAX_CONCURRENT_CHANNELS_PER_SLAVE);
        return value != null ? Integer.parseInt(value) : 20;
    }

    public static int getMaxConcurrentTransactionsOnMasterFromConfig(Map<String, String> config) {
        String value = config.get(CONFIG_KEY_MAX_CONCURRENT_TRANSACTIONS_ON_MASTER);
        return value != null ? Integer.parseInt(value) : 200;
    }

    public static String getClusterNameFromConfig(Map<String, String> config) {
        String clusterName = config.get(CONFIG_KEY_CLUSTER_NAME);
        return clusterName != null ? clusterName : CONFIG_DEFAULT_HA_CLUSTER_NAME;
    }

    public static long getPullIntervalFromConfig(Map<String, String> config) {
        String value = config.get(CONFIG_KEY_PULL_INTERVAL);
        return value != null ? TimeUtil.parseTimeMillis(value) : -1L;
    }

    public static long getZKSessionTimeoutFromConfig(Map<String, String> config) {
        String value = config.get(CONFIG_KEY_ZK_SESSION_TIMEOUT);
        return value != null ? TimeUtil.parseTimeMillis(value) : 5000L;
    }

    public static String getHaServerFromConfig(Map<String, String> config) {
        String haServer = config.get(CONFIG_KEY_SERVER);
        if (haServer == null) {
            InetAddress host = null;
            try {
                host = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (host == null) {
                throw new IllegalStateException("Could not auto configure host name, please supply ha.server");
            }
            haServer = host.getHostAddress() + ":" + 6361;
        }
        return haServer;
    }

    public static boolean getAllowInitFromConfig(Map<?, ?> config) {
        String allowInit = (String)config.get(CONFIG_KEY_ALLOW_INIT_CLUSTER);
        if (allowInit == null) {
            return true;
        }
        return Boolean.parseBoolean(allowInit);
    }

    public static String getCoordinatorsFromConfig(Map<String, String> config) {
        return HaConfig.getConfigValue(config, CONFIG_KEY_COORDINATORS, CONFIG_KEY_OLD_COORDINATORS);
    }

    public static int getMachineIdFromConfig(Map<String, String> config) {
        return Integer.parseInt(HaConfig.getConfigValue(config, CONFIG_KEY_SERVER_ID, CONFIG_KEY_OLD_SERVER_ID));
    }

    public static int getBackupPortFromConfig(Map<?, ?> config) {
        String backupConfig = (String)config.get("enable_online_backup");
        Integer port = OnlineBackupExtension.parsePort((String)backupConfig);
        return port != null ? port : 0;
    }

    public static int getFetchInfoTimeoutFromConfig(Map<String, String> config) {
        String value = config.get(CONFIG_KEY_COORDINATOR_FETCH_INFO_TIMEOUT);
        return value != null ? Integer.parseInt(value) : 500;
    }

    public static Map<String, String> loadConfigurations(String file) {
        return EmbeddedGraphDatabase.loadConfigurations((String)file);
    }

    public static enum SlaveUpdateMode {
        sync(true){

            @Override
            public LastCommittedTxIdSetter createUpdater(Broker broker) {
                return new ZooKeeperLastCommittedTxIdSetter(broker);
            }
        }
        ,
        async(true){

            @Override
            public LastCommittedTxIdSetter createUpdater(Broker broker) {
                return new AsyncZooKeeperLastCommittedTxIdSetter(broker);
            }
        }
        ,
        none(false){

            @Override
            public LastCommittedTxIdSetter createUpdater(Broker broker) {
                return CommonFactories.defaultLastCommittedTxIdSetter();
            }
        };

        public final boolean syncWithZooKeeper;

        private SlaveUpdateMode(boolean syncWithZooKeeper) {
            this.syncWithZooKeeper = syncWithZooKeeper;
        }

        public abstract LastCommittedTxIdSetter createUpdater(Broker var1);
    }
}

