/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;

public class HaCaches
implements Caches {
    private CacheProvider type;
    private Map<Object, Object> config;
    private Cache<NodeImpl> node;
    private Cache<RelationshipImpl> relationship;
    private final StringLogger logger;

    public HaCaches(StringLogger logger) {
        this.logger = logger;
    }

    public void configure(CacheProvider newType, Map<Object, Object> config) {
        if (!this.cacheConfigSame(newType, config)) {
            this.node = newType.newNodeCache(this.logger, config);
            this.relationship = newType.newRelationshipCache(this.logger, config);
        } else {
            this.node.clear();
            this.relationship.clear();
        }
        this.type = newType;
        this.config = config;
    }

    private boolean cacheConfigSame(CacheProvider type, Map<Object, Object> config) {
        return this.type != null && this.type.getName().equals(type.getName()) && "gcr".equals(this.type.getName()) && Float.parseFloat((String)this.config.get("node_cache_array_fraction")) == Float.parseFloat((String)config.get("node_cache_array_fraction")) && Float.parseFloat((String)this.config.get("relationship_cache_array_fraction")) == Float.parseFloat((String)config.get("relationship_cache_array_fraction")) && this.stringSettingSame(config, "node_cache_size") && this.stringSettingSame(config, "relationship_cache_size");
    }

    private boolean stringSettingSame(Map<Object, Object> otherConfig, String setting) {
        String otherValue;
        String myValue = (String)this.config.get(setting);
        return myValue == (otherValue = (String)this.config.get(setting)) || myValue != null && myValue.equals(otherValue);
    }

    public Cache<NodeImpl> node() {
        return this.node;
    }

    public Cache<RelationshipImpl> relationship() {
        return this.relationship;
    }

    public void invalidate() {
        this.type = null;
        this.config = null;
    }
}

