/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.IOException;
import org.neo4j.com.ComException;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

class BranchDetectingTxVerifier
implements TxChecksumVerifier {
    private final AbstractGraphDatabase db;
    private XaDataSource dataSource;

    BranchDetectingTxVerifier(AbstractGraphDatabase db) {
        this.db = db;
    }

    public void assertMatch(long txId, int masterId, long checksum) {
        try {
            boolean match;
            Pair readChecksum = this.dataSource().getMasterForCommittedTx(txId);
            boolean bl = match = masterId == (Integer)readChecksum.first() && checksum == (Long)readChecksum.other();
            if (!match) {
                throw new ComException((Throwable)new BranchedDataException(this.stringify(txId, masterId, checksum) + " doesn't match " + readChecksum));
            }
        }
        catch (IOException e) {
            this.db.getMessageLog().logMessage("Couldn't verify checksum for " + this.stringify(txId, masterId, checksum), (Throwable)e);
            throw new BranchedDataException(e);
        }
    }

    private XaDataSource dataSource() {
        if (this.dataSource == null) {
            this.dataSource = this.db.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
        }
        return this.dataSource;
    }

    private String stringify(long txId, int masterId, long checksum) {
        return "txId:" + txId + ", masterId:" + masterId + ", checksum:" + checksum;
    }
}

