/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.HaConfig;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.zookeeper.BranchDetectingTxVerifier;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperMachine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.management.Neo4jManager;

public class ZooKeeperBroker
extends AbstractBroker {
    private volatile ZooClient zooClient;
    private final String haServer;
    private int clientLockReadTimeout;
    private final Map<String, String> config;
    private int fetchInfoTimeout;
    private final ResponseReceiver receiver;

    public ZooKeeperBroker(AbstractGraphDatabase graphDb, Map<String, String> config, ResponseReceiver receiver) {
        super(HaConfig.getMachineIdFromConfig(config), graphDb);
        this.config = config;
        this.haServer = HaConfig.getHaServerFromConfig(config);
        this.clientLockReadTimeout = HaConfig.getClientLockReadTimeoutFromConfig(config);
        this.fetchInfoTimeout = HaConfig.getFetchInfoTimeoutFromConfig(config);
        this.receiver = receiver;
        this.start();
    }

    @Override
    public void logStatus(StringLogger msgLog) {
        for (String server : this.zooClient.getServers().split(",")) {
            msgLog.logMessage(this.zkStatus(server, "conf"));
            msgLog.logMessage(this.zkStatus(server, "envi"));
            msgLog.logMessage(this.zkStatus(server, "srvr"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String zkStatus(String server, String command) {
        int port;
        StringBuilder result = new StringBuilder("ZooKeeper status: ").append(server).append(" ").append(command);
        String[] hostAndPort = server.split(":");
        if (hostAndPort.length != 2) {
            return result.append(" BAD SERVER STRING").toString();
        }
        String host = hostAndPort[0];
        try {
            port = Integer.parseInt(hostAndPort[1]);
        }
        catch (NumberFormatException e) {
            return result.append(" BAD SERVER STRING").toString();
        }
        InetSocketAddress sockAddr = new InetSocketAddress(host, port);
        try {
            Socket soc = new Socket();
            soc.connect(sockAddr, this.fetchInfoTimeout);
            BufferedReader in = new BufferedReader(new InputStreamReader(soc.getInputStream()));
            try {
                PrintWriter out = new PrintWriter(soc.getOutputStream(), true);
                try {
                    String line;
                    out.println(command);
                    while ((line = in.readLine()) != null) {
                        result.append("\n  ").append(line);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            result.append(" FAILED: " + e);
        }
        return result.toString();
    }

    @Override
    public StoreId getClusterStoreId() {
        return this.zooClient.getClusterStoreId();
    }

    @Override
    public void setConnectionInformation(KernelData kernel) {
        String instanceId = kernel.instanceId();
        JMXServiceURL url = Neo4jManager.getConnectionURL((KernelData)kernel);
        if (instanceId != null && url != null) {
            this.zooClient.setJmxConnectionData(url, instanceId);
        }
    }

    @Override
    public ConnectionInformation getConnectionInformation(int machineId) {
        for (ConnectionInformation connection : this.getConnectionInformation()) {
            if (connection.getMachineId() != machineId) continue;
            return connection;
        }
        return null;
    }

    @Override
    public ConnectionInformation[] getConnectionInformation() {
        Map<Integer, ZooKeeperMachine> machines = this.zooClient.getAllMachines(false);
        ZooKeeperMachine master = this.zooClient.getMasterBasedOn(machines.values());
        ConnectionInformation[] result = new ConnectionInformation[machines.size()];
        int i = 0;
        for (ZooKeeperMachine machine : machines.values()) {
            result[i++] = this.addJmxInfo(new ConnectionInformation(machine, master.equals(machine)));
        }
        return result;
    }

    private ConnectionInformation addJmxInfo(ConnectionInformation connect) {
        this.zooClient.getJmxConnectionData(connect);
        return connect;
    }

    @Override
    public Pair<Master, Machine> getMaster() {
        return this.zooClient.getCachedMaster();
    }

    @Override
    public Pair<Master, Machine> getMasterReally(boolean allowChange) {
        return this.zooClient.getMasterFromZooKeeper(true, allowChange);
    }

    @Override
    public Machine getMasterExceptMyself() {
        Map<Integer, ZooKeeperMachine> machines = this.zooClient.getAllMachines(true);
        machines.remove(this.getMyMachineId());
        return this.zooClient.getMasterBasedOn(machines.values());
    }

    @Override
    public Object instantiateMasterServer(AbstractGraphDatabase graphDb) {
        MasterServer server = new MasterServer(new MasterImpl((GraphDatabaseService)graphDb, this.config), (Integer)Machine.splitIpAndPort(this.haServer).other(), graphDb.getMessageLog(), HaConfig.getMaxConcurrentTransactionsOnMasterFromConfig(this.config), this.clientLockReadTimeout, new BranchDetectingTxVerifier(graphDb));
        return server;
    }

    @Override
    public void setLastCommittedTxId(long txId) {
        this.zooClient.setCommittedTx(txId);
    }

    @Override
    public boolean iAmMaster() {
        return ((Machine)this.zooClient.getCachedMaster().other()).getMachineId() == this.getMyMachineId();
    }

    @Override
    public synchronized void start() {
        if (this.zooClient != null) {
            throw new IllegalStateException("Broker already started, ZooClient is " + this.zooClient);
        }
        this.zooClient = new ZooClient(this.getGraphDb(), this.config, this.receiver);
    }

    @Override
    public synchronized void shutdown() {
        if (this.zooClient == null) {
            throw new IllegalStateException("Broker already shutdown");
        }
        this.zooClient.shutdown();
        this.zooClient = null;
    }

    @Override
    public synchronized void restart() {
        this.shutdown();
        this.start();
    }

    @Override
    public void rebindMaster() {
        this.zooClient.setDataChangeWatcher("master-rebound", this.getMyMachineId());
    }

    @Override
    public void notifyMasterChange(Machine newMaster) {
        this.zooClient.setDataChangeWatcher("master-notify", newMaster.getMachineId());
    }

    protected ZooClient getZooClient() {
        return this.zooClient;
    }
}

