/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Map;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.GCResistantCache;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;

public class GCResistantCacheProvider
extends CacheProvider {
    public static final String NAME = "gcr";

    public GCResistantCacheProvider() {
        super(NAME, "GC resistant cache");
    }

    public Cache<NodeImpl> newNodeCache(StringLogger logger, Map<Object, Object> params) {
        long mem = this.memToUse(logger, params, true);
        return new GCResistantCache<NodeImpl>(mem, this.fraction(params, "node_cache_array_fraction"), this.minLogInterval(params), "NodeCache", logger);
    }

    public Cache<RelationshipImpl> newRelationshipCache(StringLogger logger, Map<Object, Object> params) {
        long mem = this.memToUse(logger, params, false);
        return new GCResistantCache<RelationshipImpl>(mem, this.fraction(params, "relationship_cache_array_fraction"), this.minLogInterval(params), "RelationshipCache", logger);
    }

    private long minLogInterval(Map<Object, Object> params) {
        String interval = (String)params.get("gcr_cache_min_log_interval");
        long result = 60000L;
        try {
            if (interval != null) {
                result = TimeUtil.parseTimeMillis((String)interval);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid configuration value [" + interval + "] for " + "gcr_cache_min_log_interval", e);
        }
        if (result < 0L) {
            throw new IllegalArgumentException("Invalid configuration value [" + interval + "] for " + "gcr_cache_min_log_interval");
        }
        return result;
    }

    private long memToUse(StringLogger logger, Map<Object, Object> params, boolean isNode) {
        Long node = this.memory(params, "node_cache_size");
        Long rel = this.memory(params, "relationship_cache_size");
        long available = Runtime.getRuntime().maxMemory();
        long advicedMax = available / 2L;
        long advicedMaxPerCache = advicedMax / 2L;
        if (node == null && isNode || rel == null && !isNode) {
            return advicedMaxPerCache;
        }
        long total = 0L;
        node = node != null ? node : advicedMaxPerCache;
        rel = rel != null ? rel : advicedMaxPerCache;
        node = Math.max(1L, node);
        total += node.longValue();
        if ((total += (rel = Long.valueOf(Math.max(1L, rel))).longValue()) > available) {
            throw new IllegalArgumentException(String.format("Configured cache memory limits (node=%s, relationship=%s, total=%s) exceeds available heap space (%s)", node, rel, total, available));
        }
        if (total > advicedMax) {
            logger.logMessage(String.format("Configured cache memory limits(node=%s, relationship=%s, total=%s) exceeds recommended limit (%s)", node, rel, total, advicedMax));
        }
        if (node == null) {
            node = Math.max(1L, advicedMax - rel);
        }
        if (rel == null) {
            rel = Math.max(1L, advicedMax - node);
        }
        return isNode ? node : rel;
    }

    private float fraction(Map<Object, Object> params, String param) {
        String fraction = (String)params.get("node_cache_array_fraction");
        float result = 1.0f;
        try {
            if (fraction != null) {
                result = Float.parseFloat(fraction);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid configuration value [" + fraction + "] for " + param, e);
        }
        if (result < 1.0f || result > 10.0f) {
            throw new IllegalArgumentException("Invalid configuration value [" + fraction + "] for " + param);
        }
        return result;
    }

    private Long memory(Map<Object, Object> params, String param) {
        Object config = params.get(param);
        if (config != null) {
            String mem = config.toString();
            mem = mem.trim().toLowerCase();
            long multiplier = 1L;
            if (mem.endsWith("m")) {
                multiplier = 0x100000L;
                mem = mem.substring(0, mem.length() - 1);
            } else if (mem.endsWith("k")) {
                multiplier = 1024L;
                mem = mem.substring(0, mem.length() - 1);
            } else if (mem.endsWith("g")) {
                multiplier = 0x40000000L;
                mem = mem.substring(0, mem.length() - 1);
            }
            try {
                return Long.parseLong(mem) * multiplier;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid configuration value [" + mem + "] for " + param, e);
            }
        }
        return null;
    }
}

