/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaCaches;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.ImpermanentGraphDatabase;

public class TestCacheObjectReuse {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gcrCachesCanBeReusedBetweenSessions() throws Exception {
        HaImpermanentGraphDatabase db = new HaImpermanentGraphDatabase(MapUtil.stringMap((String[])new String[]{"cache_type", "gcr"}));
        Cache firstCache = (Cache)IteratorUtil.first((Iterable)db.getConfig().getGraphDbModule().getNodeManager().caches());
        db.shutdown();
        db = new HaImpermanentGraphDatabase(MapUtil.stringMap((String[])new String[]{"cache_type", "gcr"}));
        try {
            Cache secondCache = (Cache)IteratorUtil.first((Iterable)db.getConfig().getGraphDbModule().getNodeManager().caches());
            Assert.assertEquals((Object)firstCache, (Object)secondCache);
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gcrCachesAreRecreatedBetweenSessionsIfConfigChanges() throws Exception {
        HaImpermanentGraphDatabase db = new HaImpermanentGraphDatabase(MapUtil.stringMap((String[])new String[]{"cache_type", "gcr"}));
        Cache firstCache = (Cache)IteratorUtil.first((Iterable)db.getConfig().getGraphDbModule().getNodeManager().caches());
        db.shutdown();
        db = new HaImpermanentGraphDatabase(MapUtil.stringMap((String[])new String[]{"cache_type", "gcr", "node_cache_array_fraction", "10"}));
        try {
            Cache secondCache = (Cache)IteratorUtil.first((Iterable)db.getConfig().getGraphDbModule().getNodeManager().caches());
            Assert.assertFalse((boolean)firstCache.equals(secondCache));
        }
        finally {
            db.shutdown();
        }
    }

    private static class HaImpermanentGraphDatabase
    extends ImpermanentGraphDatabase {
        private static String lastStoreDir;
        private static HaCaches caches;

        public HaImpermanentGraphDatabase(Map<String, String> config) {
            super(config);
        }

        protected Caches createCaches(StringLogger logger) {
            if (caches == null) {
                caches = new HaCaches(this.getMessageLog());
            } else if (lastStoreDir == null || !lastStoreDir.equals(this.getStoreDir())) {
                caches.invalidate();
            }
            lastStoreDir = this.getStoreDir();
            return caches;
        }
    }
}

