/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.reflect.Method;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.SizeOfs;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.test.ImpermanentGraphDatabase;

@Ignore
public class TestSizeOf {
    private static ImpermanentGraphDatabase db;

    @BeforeClass
    public static void setupDB() {
        db = new ImpermanentGraphDatabase(MapUtil.stringMap((String[])new String[]{"cache_type", "gcr"}));
    }

    @AfterClass
    public static void shutdown() throws Exception {
        db.shutdown();
    }

    @Before
    public void clearCache() {
        db.getConfig().getGraphDbModule().getNodeManager().clearCache();
    }

    private Cache<NodeImpl> getNodeCache() {
        return (Cache)IteratorUtil.first((Iterable)db.getConfig().getGraphDbModule().getNodeManager().caches());
    }

    private Cache<RelationshipImpl> getRelationshipCache() {
        return (Cache)IteratorUtil.last((Iterable)db.getConfig().getGraphDbModule().getNodeManager().caches());
    }

    private Node createNodeAndLoadFresh(Map<String, Object> properties, int nrOfRelationships, int nrOfTypes) {
        return this.createNodeAndLoadFresh(properties, nrOfRelationships, nrOfTypes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNodeAndLoadFresh(Map<String, Object> properties, int nrOfRelationships, int nrOfTypes, int directionStride) {
        Node node = null;
        Transaction tx = db.beginTx();
        try {
            node = db.createNode();
            this.setProperties(properties, (PropertyContainer)node);
            for (int t = 0; t < nrOfTypes; ++t) {
                DynamicRelationshipType type = DynamicRelationshipType.withName((String)this.relTypeName(t));
                int dir = 0;
                for (int i = 0; i < nrOfRelationships; ++i) {
                    switch (dir) {
                        case 0: {
                            node.createRelationshipTo(db.createNode(), (RelationshipType)type);
                            break;
                        }
                        case 1: {
                            db.createNode().createRelationshipTo(node, (RelationshipType)type);
                            break;
                        }
                        case 2: {
                            node.createRelationshipTo(node, (RelationshipType)type);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid direction " + dir);
                        }
                    }
                    dir = (dir + directionStride) % 3;
                }
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        this.clearCache();
        if (!properties.isEmpty()) {
            this.loadProperties((PropertyContainer)node);
        }
        if (nrOfRelationships * nrOfTypes > 0) {
            IteratorUtil.count((Iterable)node.getRelationships());
        }
        return node;
    }

    private void loadProperties(PropertyContainer entity) {
        for (String key : entity.getPropertyKeys()) {
            entity.getProperty(key);
        }
    }

    private void setProperties(Map<String, Object> properties, PropertyContainer entity) {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            entity.setProperty(property.getKey(), property.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Relationship createRelationshipAndLoadFresh(Map<String, Object> properties) {
        Relationship relationship = null;
        Transaction tx = db.beginTx();
        try {
            relationship = db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            this.setProperties(properties, (PropertyContainer)relationship);
            tx.success();
        }
        finally {
            tx.finish();
        }
        this.clearCache();
        if (!properties.isEmpty()) {
            this.loadProperties((PropertyContainer)relationship);
        }
        return relationship;
    }

    private String relTypeName(int t) {
        return "mytype" + t;
    }

    @Test
    public void cacheSizeCorrelatesWithNodeSizeAfterFullyLoadingRelationships() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 10, 1);
        Cache<NodeImpl> nodeCache = this.getNodeCache();
        this.clearCache();
        Assert.assertEquals((long)0L, (long)nodeCache.size());
        IteratorUtil.count((Iterable)node.getRelationships());
        Assert.assertEquals((long)db.getConfig().getGraphDbModule().getNodeManager().getNodeIfCached(node.getId()).size(), (long)nodeCache.size());
    }

    private int sizeOfNode(Node node) throws Exception {
        NodeManager nm = db.getConfig().getGraphDbModule().getNodeManager();
        Class<?> nodeProxyClass = Class.forName("org.neo4j.kernel.impl.core.NodeProxy");
        Method getNodeForProxy = nm.getClass().getDeclaredMethod("getNodeForProxy", nodeProxyClass, LockType.class);
        getNodeForProxy.setAccessible(true);
        NodeImpl nodeImpl = (NodeImpl)getNodeForProxy.invoke((Object)nm, node, null);
        return nodeImpl.size();
    }

    private int sizeOfRelationship(Relationship relationship) throws Exception {
        NodeManager nm = db.getConfig().getGraphDbModule().getNodeManager();
        Class<?> relationshipProxyClass = Class.forName("org.neo4j.kernel.impl.core.RelationshipProxy");
        Method getRelForProxy = nm.getClass().getDeclaredMethod("getRelForProxy", relationshipProxyClass, LockType.class);
        getRelForProxy.setAccessible(true);
        RelationshipImpl relImpl = (RelationshipImpl)getRelForProxy.invoke((Object)nm, relationship, null);
        return relImpl.size();
    }

    private int withNodeOverhead(int size) {
        return SizeOfs.withObjectOverhead((int)(40 + size));
    }

    private int withRelationshipOverhead(int size) {
        return SizeOfs.withObjectOverhead((int)(32 + size));
    }

    private int sizeOfRelIdArray(String type, int nrOut, int nrIn, int nrLoop) {
        int size = 24 + SizeOfs.sizeOf((String)type);
        for (int rels : new int[]{nrOut, nrIn, nrLoop}) {
            if (rels <= 0) continue;
            size += SizeOfs.withObjectOverhead((int)SizeOfs.withReference((int)SizeOfs.withArrayOverhead((int)(4 * (rels + 1)))));
        }
        if (nrLoop > 0) {
            size += 8;
        }
        return SizeOfs.withObjectOverhead((int)size);
    }

    @Test
    public void sizeOfEmptyNode() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 0, 0);
        Assert.assertEquals((long)this.withNodeOverhead(0), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithOneProperty() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[]{"age", 5}), 0, 0);
        Assert.assertEquals((long)this.withNodeOverhead(SizeOfs.withArrayOverhead((int)SizeOfs.withObjectOverhead((int)16), (int)1)), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithSomeProperties() throws Exception {
        String name = "Mattias";
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[]{"age", 5, "name", name}), 0, 0);
        Assert.assertEquals((long)this.withNodeOverhead(SizeOfs.withArrayOverhead((int)(SizeOfs.withObjectOverhead((int)16) + SizeOfs.withObjectOverhead((int)(20 + SizeOfs.sizeOf((String)name)))), (int)2)), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithOneRelationship() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 1, 1);
        Assert.assertEquals((long)this.withNodeOverhead(SizeOfs.withArrayOverhead((int)this.sizeOfRelIdArray(this.relTypeName(0), 1, 0, 0), (int)1)), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithSomeRelationshipsOfSameType() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 10, 1);
        Assert.assertEquals((long)this.withNodeOverhead(SizeOfs.withArrayOverhead((int)this.sizeOfRelIdArray(this.relTypeName(0), 10, 0, 0), (int)1)), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithSomeRelationshipOfDifferentTypes() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 3, 3);
        Assert.assertEquals((long)this.withNodeOverhead(SizeOfs.withArrayOverhead((int)(this.sizeOfRelIdArray(this.relTypeName(0), 3, 0, 0) + this.sizeOfRelIdArray(this.relTypeName(1), 3, 0, 0) + this.sizeOfRelIdArray(this.relTypeName(2), 3, 0, 0)), (int)3)), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithSomeRelationshipOfDifferentTypesAndDirections() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 9, 3, 1);
        Assert.assertEquals((long)this.withNodeOverhead(SizeOfs.withArrayOverhead((int)(this.sizeOfRelIdArray(this.relTypeName(0), 3, 3, 3) + this.sizeOfRelIdArray(this.relTypeName(1), 3, 3, 3) + this.sizeOfRelIdArray(this.relTypeName(2), 3, 3, 3)), (int)3)), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithRelationshipsAndProperties() throws Exception {
        int[] array = new int[]{10, 11, 12, 13};
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[]{"age", 10, "array", array}), 9, 3, 1);
        Assert.assertEquals((long)this.withNodeOverhead(SizeOfs.withArrayOverhead((int)(this.sizeOfRelIdArray(this.relTypeName(0), 3, 3, 3) + this.sizeOfRelIdArray(this.relTypeName(1), 3, 3, 3) + this.sizeOfRelIdArray(this.relTypeName(2), 3, 3, 3)), (int)3) + SizeOfs.withArrayOverhead((int)(SizeOfs.withObjectOverhead((int)16) + SizeOfs.withObjectOverhead((int)(20 + SizeOfs.sizeOfArray((Object)array)))), (int)2)), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfEmptyRelationship() throws Exception {
        Relationship relationship = this.createRelationshipAndLoadFresh(MapUtil.map((Object[])new Object[0]));
        Assert.assertEquals((long)this.withRelationshipOverhead(0), (long)this.sizeOfRelationship(relationship));
    }

    @Test
    public void sizeOfRelationshipWithOneProperty() throws Exception {
        Relationship relationship = this.createRelationshipAndLoadFresh(MapUtil.map((Object[])new Object[]{"age", 5}));
        Assert.assertEquals((long)this.withRelationshipOverhead(SizeOfs.withArrayOverhead((int)SizeOfs.withObjectOverhead((int)16), (int)1)), (long)this.sizeOfRelationship(relationship));
    }

    @Test
    public void sizeOfRelationshipWithSomeProperties() throws Exception {
        String name = "Mattias";
        Relationship relationship = this.createRelationshipAndLoadFresh(MapUtil.map((Object[])new Object[]{"age", 5, "name", name}));
        Assert.assertEquals((long)this.withRelationshipOverhead(SizeOfs.withArrayOverhead((int)(SizeOfs.withObjectOverhead((int)16) + SizeOfs.withObjectOverhead((int)(20 + SizeOfs.sizeOf((String)name)))), (int)2)), (long)this.sizeOfRelationship(relationship));
    }
}

