/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Ignore;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.HAGraphDb;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.ClusterClient;
import org.neo4j.kernel.ha.FakeClusterClient;
import org.neo4j.kernel.ha.FakeMasterBroker;
import org.neo4j.kernel.ha.FakeSlaveBroker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import slavetest.AbstractHaTest;
import slavetest.CommonJobs;
import slavetest.DoubleLatch;
import slavetest.Fetcher;
import slavetest.Job;
import slavetest.PlaceHolderGraphDatabaseService;

@Ignore(value="SingleJvmWithNettyTest covers this and more")
public class SingleJvmTest
extends AbstractHaTest {
    private MasterImpl master;
    private List<GraphDatabaseService> haDbs;

    protected GraphDatabaseService getSlave(int nr) {
        return this.haDbs.get(nr);
    }

    @Override
    protected int addDb(Map<String, String> config, boolean awaitStarted) {
        this.haDbs = this.haDbs != null ? this.haDbs : new ArrayList<GraphDatabaseService>();
        int machineId = this.haDbs.size() + 1;
        this.haDbs.add(null);
        this.startDb(machineId, config, awaitStarted);
        return machineId;
    }

    @Override
    protected void startDb(int machineId, Map<String, String> config, boolean awaitStarted) {
        this.haDbs = this.haDbs != null ? this.haDbs : new ArrayList<GraphDatabaseService>();
        File slavePath = this.dbPath(machineId);
        PlaceHolderGraphDatabaseService placeHolderDb = new PlaceHolderGraphDatabaseService(slavePath.getAbsolutePath());
        Broker broker = this.makeSlaveBroker(this.master, 0, machineId, placeHolderDb, config);
        HashMap<String, String> cfg = new HashMap<String, String>(config);
        cfg.put("ha.server_id", Integer.toString(machineId));
        cfg.put("keep_logical_logs", "true");
        this.addDefaultReadTimeout(cfg);
        HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(new HAGraphDb(slavePath.getAbsolutePath(), cfg, SingleJvmTest.wrapBrokerAndSetPlaceHolderDb(placeHolderDb, broker), this.makeMasterClusterClientFromBroker(broker)));
        placeHolderDb.setDb((GraphDatabaseService)db);
        this.haDbs.set(machineId - 1, (GraphDatabaseService)db);
    }

    @Override
    protected void awaitAllStarted() throws Exception {
    }

    @Override
    protected void shutdownDb(int machineId) {
        this.haDbs.get(machineId - 1).shutdown();
    }

    @Override
    protected void startUpMaster(Map<String, String> extraConfig) throws Exception {
        this.master = new MasterImpl((GraphDatabaseService)this.startUpMasterDb(extraConfig), extraConfig);
    }

    protected PlaceHolderGraphDatabaseService startUpMasterDb(Map<String, String> extraConfig) throws Exception {
        int masterId = 0;
        Map config = MapUtil.stringMap(extraConfig, (String[])new String[]{"ha.server_id", String.valueOf(masterId)});
        this.addDefaultReadTimeout(config);
        String path = this.dbPath(0).getAbsolutePath();
        PlaceHolderGraphDatabaseService placeHolderDb = new PlaceHolderGraphDatabaseService(path);
        Broker broker = this.makeMasterBroker(masterId, placeHolderDb, config);
        HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(new HAGraphDb(path, config, SingleJvmTest.wrapBrokerAndSetPlaceHolderDb(placeHolderDb, broker), this.makeMasterClusterClientFromBroker(broker)));
        placeHolderDb.setDb((GraphDatabaseService)db);
        return placeHolderDb;
    }

    private void addDefaultReadTimeout(Map<String, String> config) {
        if (!config.containsKey("ha.read_timeout")) {
            config.put("ha.read_timeout", String.valueOf(3));
        }
    }

    protected Broker makeMasterBroker(int masterId, AbstractGraphDatabase graphDb, Map<String, String> config) {
        return new FakeMasterBroker(masterId, graphDb, config);
    }

    protected Broker makeSlaveBroker(MasterImpl master, int masterId, int id, AbstractGraphDatabase graphDb, Map<String, String> config) {
        return new FakeSlaveBroker((Master)master, masterId, id, graphDb);
    }

    protected ClusterClient makeMasterClusterClientFromBroker(Broker broker) {
        return new FakeClusterClient(broker);
    }

    protected MasterImpl getMaster() {
        return this.master;
    }

    @Override
    protected void shutdownDbs() {
        for (GraphDatabaseService haDb : this.haDbs) {
            haDb.shutdown();
        }
        this.master.getGraphDb().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void verifyAndShutdownDbs() {
        try {
            this.verify(this.master.getGraphDb(), this.haDbs.toArray(new GraphDatabaseService[this.haDbs.size()]));
        }
        finally {
            this.shutdownDbs();
        }
        if (!this.shouldDoVerificationAfterTests()) {
            return;
        }
        EmbeddedGraphDatabase masterOfflineDb = new EmbeddedGraphDatabase(this.dbPath(0).getAbsolutePath());
        GraphDatabaseService[] slaveOfflineDbs = new GraphDatabaseService[this.haDbs.size()];
        for (int i = 1; i <= this.haDbs.size(); ++i) {
            slaveOfflineDbs[i - 1] = new EmbeddedGraphDatabase(this.dbPath(i).getAbsolutePath());
        }
        try {
            this.verify((GraphDatabaseService)masterOfflineDb, slaveOfflineDbs);
        }
        finally {
            masterOfflineDb.shutdown();
            for (GraphDatabaseService db : slaveOfflineDbs) {
                db.shutdown();
            }
        }
        this.shutdownMaster();
    }

    @Override
    protected <T> T executeJob(Job<T> job, int slave) throws Exception {
        return job.execute(this.haDbs.get(slave));
    }

    @Override
    protected <T> T executeJobOnMaster(Job<T> job) throws Exception {
        return job.execute(this.master.getGraphDb());
    }

    @Override
    protected void pullUpdates(int ... ids) {
        if (ids.length == 0) {
            for (GraphDatabaseService db : this.haDbs) {
                ((HighlyAvailableGraphDatabase)db).pullUpdates();
            }
        } else {
            for (int id : ids) {
                ((HighlyAvailableGraphDatabase)this.haDbs.get(id)).pullUpdates();
            }
        }
    }

    @Override
    protected CommonJobs.ShutdownDispatcher getMasterShutdownDispatcher() {
        return new CommonJobs.ShutdownDispatcher(){

            @Override
            public void doShutdown() {
                SingleJvmTest.this.shutdownMaster();
            }
        };
    }

    @Override
    protected Fetcher<DoubleLatch> getDoubleLatch() {
        return new Fetcher<DoubleLatch>(){
            private final DoubleLatch latch = new DoubleLatch(){
                private final CountDownLatch first = new CountDownLatch(1);
                private final CountDownLatch second = new CountDownLatch(1);

                @Override
                public void countDownSecond() {
                    this.second.countDown();
                }

                @Override
                public void countDownFirst() {
                    this.first.countDown();
                }

                @Override
                public void awaitSecond() {
                    this.await(this.second);
                }

                @Override
                public void awaitFirst() {
                    this.await(this.first);
                }

                private void await(CountDownLatch latch) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        e.printStackTrace();
                    }
                }
            };

            @Override
            public DoubleLatch fetch() {
                return this.latch;
            }

            @Override
            public void close() {
            }
        };
    }

    protected void shutdownMaster() {
        this.getMasterHaDb().shutdown();
        this.getMaster().shutdown();
    }

    protected HighlyAvailableGraphDatabase getMasterHaDb() {
        return (HighlyAvailableGraphDatabase)this.getMaster().getGraphDb();
    }
}

