/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;

public class AsyncZooKeeperLastCommittedTxIdSetter
implements LastCommittedTxIdSetter {
    private final Broker broker;
    private final Updater updater;

    public AsyncZooKeeperLastCommittedTxIdSetter(Broker broker) {
        this.broker = broker;
        this.updater = new Updater();
        this.updater.start();
    }

    public void setLastCommittedTxId(long txId) {
        this.updater.setTarget(txId);
    }

    public void close() {
        this.updater.halt();
        try {
            this.updater.join();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private class Updater
    extends Thread {
        private volatile long targetTxId;
        private long lastUpdatedTxId;
        private boolean halted;

        private Updater() {
        }

        @Override
        public void run() {
            while (!this.halted) {
                long txId = this.targetTxId;
                if (txId == this.lastUpdatedTxId) {
                    this.waitForAChange();
                    continue;
                }
                try {
                    AsyncZooKeeperLastCommittedTxIdSetter.this.broker.setLastCommittedTxId(txId);
                    this.lastUpdatedTxId = txId;
                }
                catch (Exception exception) {}
            }
        }

        private synchronized void setTarget(long txId) {
            this.targetTxId = txId;
            this.notify();
        }

        private synchronized void waitForAChange() {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }

        private synchronized void halt() {
            this.halted = true;
            this.notify();
        }
    }
}

