/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.com.ComException;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.LockManagerFactory;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.LockStatus;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.TxModule;

public class SlaveLockManager
extends LockManager {
    private final Broker broker;
    private final TransactionManager tm;
    private final ResponseReceiver receiver;
    private final TxHook txHook;

    public SlaveLockManager(TransactionManager tm, TxHook txHook, Broker broker, ResponseReceiver receiver) {
        super(tm);
        this.tm = tm;
        this.txHook = txHook;
        this.broker = broker;
        this.receiver = receiver;
    }

    private int getLocalTxId() {
        return ((TxManager)this.tm).getEventIdentifier();
    }

    public void getReadLock(Object resource) throws DeadlockDetectedException, IllegalResourceException {
        LockGrabber grabber = null;
        if (resource instanceof Node) {
            grabber = LockGrabber.NODE_READ;
        } else if (resource instanceof Relationship) {
            grabber = LockGrabber.RELATIONSHIP_READ;
        } else if (resource instanceof GraphProperties) {
            grabber = LockGrabber.GRAPH_READ;
        }
        try {
            if (grabber == null) {
                super.getReadLock(resource);
                return;
            }
            this.initializeTxIfFirst();
            LockResult result = null;
            do {
                int eventIdentifier = this.getLocalTxId();
                result = this.receiver.receive(grabber.acquireLock((Master)this.broker.getMaster().first(), this.receiver.getSlaveContext(eventIdentifier), resource));
                switch (result.getStatus()) {
                    case OK_LOCKED: {
                        super.getReadLock(resource);
                        return;
                    }
                    case DEAD_LOCKED: {
                        throw new DeadlockDetectedException(result.getDeadlockMessage());
                    }
                }
            } while (result.getStatus() == LockStatus.NOT_LOCKED);
        }
        catch (ZooKeeperException e) {
            this.receiver.newMaster(e);
            throw e;
        }
        catch (ComException e) {
            this.receiver.newMaster((Exception)((Object)e));
            throw e;
        }
    }

    private void initializeTxIfFirst() {
        try {
            Transaction tx = this.tm.getTransaction();
            if (!this.txHook.hasAnyLocks(tx)) {
                this.txHook.initializeTransaction(((TxManager)this.tm).getEventIdentifier());
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void getWriteLock(Object resource) throws DeadlockDetectedException, IllegalResourceException {
        LockGrabber grabber = null;
        if (resource instanceof Node) {
            grabber = LockGrabber.NODE_WRITE;
        } else if (resource instanceof Relationship) {
            grabber = LockGrabber.RELATIONSHIP_WRITE;
        } else if (resource instanceof GraphProperties) {
            grabber = LockGrabber.GRAPH_WRITE;
        }
        try {
            if (grabber == null) {
                super.getWriteLock(resource);
                return;
            }
            this.initializeTxIfFirst();
            LockResult result = null;
            do {
                int eventIdentifier = this.getLocalTxId();
                result = this.receiver.receive(grabber.acquireLock((Master)this.broker.getMaster().first(), this.receiver.getSlaveContext(eventIdentifier), resource));
                switch (result.getStatus()) {
                    case OK_LOCKED: {
                        super.getWriteLock(resource);
                        return;
                    }
                    case DEAD_LOCKED: {
                        throw new DeadlockDetectedException(result.getDeadlockMessage());
                    }
                }
            } while (result.getStatus() == LockStatus.NOT_LOCKED);
        }
        catch (ZooKeeperException e) {
            this.receiver.newMaster(e);
            throw e;
        }
        catch (ComException e) {
            this.receiver.newMaster((Exception)((Object)e));
            throw e;
        }
    }

    private static enum LockGrabber {
        NODE_READ{

            @Override
            Response<LockResult> acquireLock(Master master, SlaveContext context, Object resource) {
                return master.acquireNodeReadLock(context, ((Node)resource).getId());
            }
        }
        ,
        NODE_WRITE{

            @Override
            Response<LockResult> acquireLock(Master master, SlaveContext context, Object resource) {
                return master.acquireNodeWriteLock(context, ((Node)resource).getId());
            }
        }
        ,
        RELATIONSHIP_READ{

            @Override
            Response<LockResult> acquireLock(Master master, SlaveContext context, Object resource) {
                return master.acquireRelationshipReadLock(context, ((Relationship)resource).getId());
            }
        }
        ,
        RELATIONSHIP_WRITE{

            @Override
            Response<LockResult> acquireLock(Master master, SlaveContext context, Object resource) {
                return master.acquireRelationshipWriteLock(context, ((Relationship)resource).getId());
            }
        }
        ,
        GRAPH_READ{

            @Override
            Response<LockResult> acquireLock(Master master, SlaveContext context, Object resource) {
                return master.acquireGraphReadLock(context);
            }
        }
        ,
        GRAPH_WRITE{

            @Override
            Response<LockResult> acquireLock(Master master, SlaveContext context, Object resource) {
                return master.acquireGraphWriteLock(context);
            }
        };


        abstract Response<LockResult> acquireLock(Master var1, SlaveContext var2, Object var3);
    }

    public static class SlaveLockManagerFactory
    implements LockManagerFactory {
        private final Broker broker;
        private final ResponseReceiver receiver;

        public SlaveLockManagerFactory(Broker broker, ResponseReceiver receiver) {
            this.broker = broker;
            this.receiver = receiver;
        }

        public LockManager create(TxModule txModule) {
            return new SlaveLockManager(txModule.getTxManager(), txModule.getTxHook(), this.broker, this.receiver);
        }
    }
}

