/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.NeoStoreUtil;
import org.neo4j.kernel.ha.zookeeper.RootPathGetter;
import org.neo4j.kernel.ha.zookeeper.ZooClient;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.management.Neo4jManager;

public class ZooKeeperBroker
extends AbstractBroker {
    private final ZooClient zooClient;
    private final String haServer;
    private final int machineId;
    private final String clusterName;

    public ZooKeeperBroker(AbstractGraphDatabase graphDb, String clusterName, int machineId, String zooKeeperServers, String haServer, int backupPort, int clientReadTimeout, int maxConcurrentChannelsPerClient, boolean writeLastCommittedTx, ResponseReceiver receiver) {
        super(machineId, (GraphDatabaseService)graphDb);
        this.clusterName = clusterName;
        this.machineId = machineId;
        this.haServer = haServer;
        this.zooClient = new ZooClient(zooKeeperServers, machineId, this.getRootPathGetter(graphDb.getStoreDir()), receiver, haServer, backupPort, clientReadTimeout, maxConcurrentChannelsPerClient, writeLastCommittedTx, graphDb);
    }

    @Override
    public void logStatus(StringLogger msgLog) {
        for (String server : this.zooClient.getServers().split(",")) {
            msgLog.logMessage(this.zkStatus(server, "conf"));
            msgLog.logMessage(this.zkStatus(server, "envi"));
            msgLog.logMessage(this.zkStatus(server, "srvr"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String zkStatus(String server, String command) {
        int port;
        StringBuilder result = new StringBuilder("ZooKeeper status: ").append(server).append(" ").append(command);
        String[] hostAndPort = server.split(":");
        if (hostAndPort.length != 2) {
            return result.append(" BAD SERVER STRING").toString();
        }
        String host = hostAndPort[0];
        try {
            port = Integer.parseInt(hostAndPort[1]);
        }
        catch (NumberFormatException e) {
            return result.append(" BAD SERVER STRING").toString();
        }
        try {
            Socket soc = new Socket(host, port);
            BufferedReader in = new BufferedReader(new InputStreamReader(soc.getInputStream()));
            try {
                PrintWriter out = new PrintWriter(soc.getOutputStream(), true);
                try {
                    String line;
                    out.println(command);
                    while ((line = in.readLine()) != null) {
                        result.append("\n  ").append(line);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            result.append(" FAILED: " + e);
        }
        return result.toString();
    }

    @Override
    public StoreId createCluster(StoreId storeIdSuggestion) {
        return this.zooClient.createCluster(this.clusterName, storeIdSuggestion);
    }

    private RootPathGetter getRootPathGetter(String storeDir) {
        try {
            new NeoStoreUtil(storeDir);
            return RootPathGetter.forKnownStore(storeDir);
        }
        catch (RuntimeException e) {
            return RootPathGetter.forUnknownStore(storeDir);
        }
    }

    @Override
    public void setConnectionInformation(KernelData kernel) {
        String instanceId = kernel.instanceId();
        JMXServiceURL url = Neo4jManager.getConnectionURL((KernelData)kernel);
        if (instanceId != null && url != null) {
            this.zooClient.setJmxConnectionData(url, instanceId);
        }
    }

    @Override
    public ConnectionInformation getConnectionInformation(int machineId) {
        for (ConnectionInformation connection : this.getConnectionInformation()) {
            if (connection.getMachineId() != machineId) continue;
            return connection;
        }
        return null;
    }

    @Override
    public ConnectionInformation[] getConnectionInformation() {
        Map<Integer, Machine> machines = this.zooClient.getAllMachines(false);
        Machine master = this.zooClient.getMasterBasedOn(machines.values());
        ConnectionInformation[] result = new ConnectionInformation[machines.size()];
        int i = 0;
        for (Machine machine : machines.values()) {
            result[i++] = this.addJmxInfo(new ConnectionInformation(machine, master.equals(machine)));
        }
        return result;
    }

    private ConnectionInformation addJmxInfo(ConnectionInformation connect) {
        this.zooClient.getJmxConnectionData(connect);
        return connect;
    }

    @Override
    public Pair<Master, Machine> getMaster() {
        return this.zooClient.getCachedMaster();
    }

    @Override
    public Pair<Master, Machine> getMasterReally(boolean allowChange) {
        return this.zooClient.getMasterFromZooKeeper(true, allowChange);
    }

    @Override
    public Machine getMasterExceptMyself() {
        Map<Integer, Machine> machines = this.zooClient.getAllMachines(true);
        machines.remove(this.machineId);
        return this.zooClient.getMasterBasedOn(machines.values());
    }

    @Override
    public Object instantiateMasterServer(AbstractGraphDatabase graphDb) {
        MasterServer server = new MasterServer(new MasterImpl((GraphDatabaseService)graphDb), (Integer)Machine.splitIpAndPort(this.haServer).other(), graphDb.getMessageLog());
        return server;
    }

    @Override
    public void setLastCommittedTxId(long txId) {
        this.zooClient.setCommittedTx(txId);
    }

    @Override
    public boolean iAmMaster() {
        return ((Machine)this.zooClient.getCachedMaster().other()).getMachineId() == this.getMyMachineId();
    }

    @Override
    public void shutdown() {
        this.zooClient.shutdown();
    }

    @Override
    public void rebindMaster() {
        this.zooClient.setDataChangeWatcher("master-rebound", this.machineId);
    }

    @Override
    public void notifyMasterChange(Machine newMaster) {
        this.zooClient.setDataChangeWatcher("master-notify", newMaster.getMachineId(), true);
    }
}

