/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.neo4j.com.ComException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.HaConfig;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.zookeeper.AbstractZooKeeperManager;
import org.neo4j.kernel.ha.zookeeper.ClusterManager;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.NeoStoreUtil;
import org.neo4j.kernel.ha.zookeeper.RootPathGetter;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperTimedOutException;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.NullLogBuffer;
import org.neo4j.kernel.impl.util.StringLogger;

public class ZooClient
extends AbstractZooKeeperManager {
    static final String MASTER_NOTIFY_CHILD = "master-notify";
    static final String MASTER_REBOUND_CHILD = "master-rebound";
    private ZooKeeper zooKeeper;
    private final int machineId;
    private String sequenceNr;
    private long committedTx;
    private int masterForCommittedTx;
    private final Object keeperStateMonitor = new Object();
    private volatile Watcher.Event.KeeperState keeperState = Watcher.Event.KeeperState.Disconnected;
    private volatile boolean shutdown = false;
    private final RootPathGetter rootPathGetter;
    private String rootPath;
    private final String haServer;
    private final StringLogger msgLog;
    private long sessionId = -1L;
    private final ResponseReceiver receiver;
    private final int backupPort;
    private final boolean writeLastCommittedTx;

    public ZooClient(AbstractGraphDatabase graphDb, Map<String, String> config, ResponseReceiver receiver) {
        super(HaConfig.getCoordinatorsFromConfig(config), graphDb, HaConfig.getClientReadTimeoutFromConfig(config), HaConfig.getClientLockReadTimeoutFromConfig(config), HaConfig.getMaxConcurrentChannelsPerSlaveFromConfig(config));
        this.receiver = receiver;
        this.machineId = HaConfig.getMachineIdFromConfig(config);
        this.backupPort = HaConfig.getBackupPortFromConfig(config);
        this.haServer = HaConfig.getHaServerFromConfig(config);
        this.writeLastCommittedTx = HaConfig.getSlaveUpdateModeFromConfig(config).syncWithZooKeeper;
        this.rootPathGetter = ZooClient.getRootPathGetter(graphDb.getStoreDir());
        this.sequenceNr = "not initialized yet";
        this.msgLog = graphDb.getMessageLog();
        this.zooKeeper = this.instantiateZooKeeper();
    }

    static RootPathGetter getRootPathGetter(String storeDir) {
        try {
            new NeoStoreUtil(storeDir);
            return RootPathGetter.forKnownStore(storeDir);
        }
        catch (RuntimeException e) {
            return RootPathGetter.forUnknownStore(storeDir);
        }
    }

    @Override
    protected int getMyMachineId() {
        return this.machineId;
    }

    public void process(WatchedEvent event) {
        block25: {
            try {
                String path = event.getPath();
                this.msgLog.logMessage(this + ", " + new Date() + " Got event: " + event + " (path=" + path + ")", true);
                if (path == null && event.getState() == Watcher.Event.KeeperState.Expired) {
                    this.keeperState = Watcher.Event.KeeperState.Expired;
                    if (this.zooKeeper != null) {
                        try {
                            this.zooKeeper.close();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            Thread.interrupted();
                        }
                    }
                    this.zooKeeper = this.instantiateZooKeeper();
                    break block25;
                }
                if (path == null && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    boolean masterBeforeIWriteDiffers;
                    long newSessionId = this.zooKeeper.getSessionId();
                    Pair<Master, Machine> masterBeforeIWrite = this.getMasterFromZooKeeper(false, false);
                    this.msgLog.logMessage("Get master before write:" + masterBeforeIWrite);
                    boolean bl = masterBeforeIWriteDiffers = ((Machine)masterBeforeIWrite.other()).getMachineId() != ((Machine)this.getCachedMaster().other()).getMachineId();
                    if (newSessionId != this.sessionId || masterBeforeIWriteDiffers) {
                        if (this.writeLastCommittedTx) {
                            this.sequenceNr = this.setup();
                            this.msgLog.logMessage("Did setup, seq=" + this.sequenceNr + " new sessionId=" + newSessionId);
                            Pair<Master, Machine> masterAfterIWrote = this.getMasterFromZooKeeper(false, false);
                            this.msgLog.logMessage("Get master after write:" + masterAfterIWrote);
                            int masterId = ((Machine)masterAfterIWrote.other()).getMachineId();
                            this.msgLog.logMessage("Set 'master-notify' to " + masterId);
                            if (this.sessionId != -1L) {
                                this.receiver.newMaster(new Exception("Got SyncConnected event from ZK"));
                            }
                            this.sessionId = newSessionId;
                        } else {
                            this.msgLog.logMessage("Didn't do setup due to told not to write");
                            this.keeperState = Watcher.Event.KeeperState.SyncConnected;
                            this.subscribeToDataChangeWatcher(MASTER_REBOUND_CHILD);
                        }
                        this.keeperState = Watcher.Event.KeeperState.SyncConnected;
                    } else {
                        this.msgLog.logMessage("SyncConnected with same session id: " + this.sessionId);
                        this.keeperState = Watcher.Event.KeeperState.SyncConnected;
                    }
                } else if (path == null && event.getState() == Watcher.Event.KeeperState.Disconnected) {
                    this.keeperState = Watcher.Event.KeeperState.Disconnected;
                } else if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                    int newMasterMachineId = this.toInt(this.getZooKeeper(true).getData(path, true, null));
                    this.msgLog.logMessage("Got event data " + newMasterMachineId);
                    if (path.contains(MASTER_NOTIFY_CHILD)) {
                        if (newMasterMachineId == this.machineId) {
                            this.receiver.newMaster(new Exception());
                        }
                    } else if (path.contains(MASTER_REBOUND_CHILD)) {
                        if (newMasterMachineId != this.machineId) {
                            this.receiver.newMaster(new Exception());
                        }
                    } else {
                        this.msgLog.logMessage("Unrecognized data change " + path);
                    }
                }
            }
            catch (Exception e) {
                this.msgLog.logMessage("Error in ZooClient.process", (Throwable)e, true);
                e.printStackTrace();
                throw Exceptions.launderedException((Throwable)e);
            }
            finally {
                this.msgLog.flush();
            }
        }
    }

    private int toInt(byte[] data) {
        return ByteBuffer.wrap(data).getInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForSyncConnected() {
        long startTime;
        if (this.keeperState == Watcher.Event.KeeperState.SyncConnected) {
            return;
        }
        if (this.shutdown) {
            throw new ZooKeeperException("ZooKeeper client has been shutdwon");
        }
        long currentTime = startTime = System.currentTimeMillis();
        Object object = this.keeperStateMonitor;
        synchronized (object) {
            do {
                try {
                    this.keeperStateMonitor.wait(250L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                if (this.keeperState == Watcher.Event.KeeperState.SyncConnected) {
                    return;
                }
                if (!this.shutdown) continue;
                throw new ZooKeeperException("ZooKeeper client has been shutdwon");
            } while ((currentTime = System.currentTimeMillis()) - startTime < 5000L);
            if (this.keeperState != Watcher.Event.KeeperState.SyncConnected) {
                throw new ZooKeeperTimedOutException("Connection to ZooKeeper server timed out, keeper state=" + this.keeperState);
            }
        }
    }

    protected void subscribeToDataChangeWatcher(String child) {
        String root = this.getRoot();
        String path = root + "/" + child;
        try {
            this.zooKeeper.getData(path, true, null);
        }
        catch (KeeperException e) {
            this.msgLog.logMessage("Couldn't get master notify node", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    protected void setDataChangeWatcher(String child, int currentMasterId) {
        try {
            boolean exists;
            byte[] data;
            String path;
            block11: {
                String root = this.getRoot();
                path = root + "/" + child;
                data = null;
                exists = false;
                try {
                    data = this.zooKeeper.getData(path, true, null);
                    exists = true;
                    if (ByteBuffer.wrap(data).getInt() == currentMasterId) {
                        this.msgLog.logMessage(child + " not set, is already " + currentMasterId);
                        return;
                    }
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) break block11;
                    throw new ZooKeeperException("Couldn't get master notify node", e);
                }
            }
            try {
                data = new byte[4];
                ByteBuffer.wrap(data).putInt(currentMasterId);
                if (!exists) {
                    this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    this.msgLog.logMessage(child + " created with " + currentMasterId);
                } else if (currentMasterId != -1) {
                    this.zooKeeper.setData(path, data, -1);
                    this.msgLog.logMessage(child + " set to " + currentMasterId);
                }
                this.zooKeeper.getData(path, true, null);
            }
            catch (KeeperException e) {
                if (e.code() != KeeperException.Code.NODEEXISTS) {
                    throw new ZooKeeperException("Couldn't set master notify node", e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    @Override
    public String getRoot() {
        this.makeSureRootPathIsFound();
        byte[] rootData = null;
        do {
            try {
                rootData = this.zooKeeper.getData(this.rootPath, false, null);
                return this.rootPath;
            }
            catch (KeeperException e) {
                if (e.code() != KeeperException.Code.NONODE) {
                    throw new ZooKeeperException("Unable to get root node", e);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Got interrupted", e);
            }
            if (ClusterManager.getSingleRootPath(this.zooKeeper) != null) {
                throw new RuntimeException("There's already an HA cluster managed by this ZooKeeper cluster");
            }
            try {
                byte[] data = new byte[]{};
                this.zooKeeper.create(this.rootPath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) continue;
                throw new ZooKeeperException("Unable to create root", e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Got interrupted", e);
            }
        } while (rootData == null);
        throw new IllegalStateException();
    }

    private void makeSureRootPathIsFound() {
        if (this.rootPath == null) {
            Pair<String, Long> info = this.rootPathGetter.getRootPath(this.zooKeeper);
            this.rootPath = (String)info.first();
            this.committedTx = (Long)info.other();
            this.masterForCommittedTx = this.getFirstMasterForTx(this.committedTx);
        }
    }

    private void cleanupChildren() {
        try {
            String root = this.getRoot();
            List children = this.zooKeeper.getChildren(root, false);
            for (String child : children) {
                Pair<Integer, Integer> parsedChild = this.parseChild(child);
                if (parsedChild == null || (Integer)parsedChild.first() != this.machineId) continue;
                this.zooKeeper.delete(root + "/" + child, -1);
            }
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to clean up old child", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted.", e);
        }
    }

    private byte[] dataRepresentingMe(long txId, int master) {
        byte[] array = new byte[12];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putLong(txId);
        buffer.putInt(master);
        return array;
    }

    private String setup() {
        try {
            this.cleanupChildren();
            this.writeHaServerConfig();
            String root = this.getRoot();
            String path = root + "/" + this.machineId + "_";
            String created = this.zooKeeper.create(path, this.dataRepresentingMe(this.committedTx, this.masterForCommittedTx), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            this.subscribeToDataChangeWatcher(MASTER_NOTIFY_CHILD);
            this.subscribeToDataChangeWatcher(MASTER_REBOUND_CHILD);
            return created.substring(created.lastIndexOf("_") + 1);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to setup", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Setup got interrupted", e);
        }
        catch (Throwable t) {
            throw new ZooKeeperException("Unknown setup error", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHaServerConfig() throws InterruptedException, KeeperException {
        String path;
        block10: {
            path = this.rootPath + "/" + "ha-servers";
            try {
                this.zooKeeper.create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block10;
                throw e;
            }
        }
        String machinePath = path + "/" + this.machineId;
        byte[] data = this.haServerAsData();
        try {
            this.zooKeeper.create(machinePath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (KeeperException e) {
            if (e.code() != KeeperException.Code.NODEEXISTS) {
                throw e;
            }
            this.msgLog.logMessage("HA server info already present, trying again");
            try {
                this.zooKeeper.delete(machinePath, -1);
            }
            catch (KeeperException ee) {
                ee.printStackTrace();
            }
            finally {
                this.writeHaServerConfig();
            }
        }
        this.zooKeeper.setData(machinePath, data, -1);
        this.msgLog.logMessage("Wrote HA server " + this.haServer + " to zoo keeper");
    }

    private byte[] haServerAsData() {
        byte[] array = new byte[this.haServer.length() * 2 + 100];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putInt(this.backupPort);
        buffer.put((byte)this.haServer.length());
        buffer.asCharBuffer().put(this.haServer.toCharArray()).flip();
        byte[] actualArray = new byte[buffer.limit()];
        System.arraycopy(array, 0, actualArray, 0, actualArray.length);
        return actualArray;
    }

    public synchronized void setJmxConnectionData(JMXServiceURL jmxUrl, String instanceId) {
        block7: {
            String path = this.rootPath + "/" + "ha-servers" + "/" + this.machineId + "-jmx";
            String url = jmxUrl.toString();
            byte[] data = new byte[(url.length() + instanceId.length()) * 2 + 4];
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.putShort((short)url.length());
            buffer.asCharBuffer().put(url.toCharArray());
            buffer.position(buffer.position() + url.length() * 2);
            buffer.putShort((short)instanceId.length());
            buffer.asCharBuffer().put(instanceId.toCharArray());
            if (buffer.limit() != data.length) {
                byte[] array = new byte[buffer.limit()];
                System.arraycopy(data, 0, array, 0, array.length);
                data = array;
            }
            try {
                try {
                    this.zooKeeper.setData(path, data, -1);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) {
                        this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                        break block7;
                    }
                    this.msgLog.logMessage("Unable to set jxm connection info", (Throwable)e);
                }
            }
            catch (KeeperException e) {
                this.msgLog.logMessage("Unable to set jxm connection info", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                this.msgLog.logMessage("Unable to set jxm connection info", (Throwable)e);
            }
        }
    }

    public void getJmxConnectionData(ConnectionInformation connection) {
        char[] instanceId;
        char[] url;
        byte[] data;
        String path = this.rootPath + "/" + "ha-servers" + "/" + this.machineId + "-jmx";
        try {
            data = this.zooKeeper.getData(path, false, null);
        }
        catch (KeeperException e) {
            return;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return;
        }
        if (data == null || data.length == 0) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        try {
            url = new char[buffer.getShort()];
            buffer.asCharBuffer().get(url);
            buffer.position(buffer.position() + url.length * 2);
            instanceId = new char[buffer.getShort()];
            buffer.asCharBuffer().get(instanceId);
        }
        catch (BufferUnderflowException e) {
            return;
        }
        connection.setJMXConnectionData(new String(url), new String(instanceId));
    }

    public synchronized void setCommittedTx(long tx) {
        int master;
        this.waitForSyncConnected();
        this.committedTx = tx;
        this.masterForCommittedTx = master = this.getMasterForTx(tx);
        String root = this.getRoot();
        String path = root + "/" + this.machineId + "_" + this.sequenceNr;
        byte[] data = this.dataRepresentingMe(tx, master);
        try {
            this.zooKeeper.setData(path, data, -1);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to set current tx", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted...", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFirstMasterForTx(long committedTx) {
        if (committedTx == 1L) {
            return -1;
        }
        LogExtractor extractor = null;
        try {
            extractor = LogExtractor.from((String)this.getGraphDb().getStoreDir(), (long)committedTx);
            long tx = extractor.extractNext(NullLogBuffer.INSTANCE);
            if (tx != committedTx) {
                throw new RuntimeException("Master for " + committedTx + " not found");
            }
            int n = extractor.getLastStartEntry().getMasterId();
            return n;
        }
        catch (IOException e) {
            this.msgLog.logMessage("Couldn't get master for " + committedTx + " using " + -1 + " temporarily", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            if (extractor != null) {
                extractor.close();
            }
        }
    }

    private int getMasterForTx(long tx) {
        try {
            return (Integer)this.getGraphDb().getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb").getMasterForCommittedTx(tx).first();
        }
        catch (IOException e) {
            throw new ComException("Master id not found for tx:" + tx, (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        super.shutdown();
    }

    @Override
    public ZooKeeper getZooKeeper(boolean sync) {
        if (sync) {
            this.zooKeeper.sync(this.rootPath, null, null);
        }
        return this.zooKeeper;
    }

    @Override
    protected String getHaServer(int machineId, boolean wait) {
        return machineId == this.machineId ? this.haServer : super.getHaServer(machineId, wait);
    }

    public synchronized StoreId createCluster(String clusterName, StoreId storeIdSuggestion) {
        String path = "/" + clusterName;
        try {
            try {
                this.zooKeeper.create(path, storeIdSuggestion.serialize(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                return storeIdSuggestion;
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    try {
                        return StoreId.deserialize((byte[])this.zooKeeper.getData(path, false, null));
                    }
                    catch (KeeperException ex) {
                        throw new ZooKeeperException("Unable to read cluster store id", ex);
                    }
                }
                throw new ZooKeeperException("Unable to write cluster store id", e);
            }
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("createCluster interrupted", e);
        }
    }
}

