/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.neo4j.com.ComException;
import org.neo4j.com.MasterUtil;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.ToFileStoreWriter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDbImpl;
import org.neo4j.kernel.HaConfig;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.LockManagerFactory;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.BrokerFactory;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterIdGeneratorFactory;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.MasterTxHook;
import org.neo4j.kernel.ha.MasterTxIdGenerator;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.SlaveIdGenerator;
import org.neo4j.kernel.ha.SlaveLockManager;
import org.neo4j.kernel.ha.SlaveRelationshipTypeCreator;
import org.neo4j.kernel.ha.SlaveTxHook;
import org.neo4j.kernel.ha.SlaveTxIdGenerator;
import org.neo4j.kernel.ha.ZooKeeperLastCommittedTxIdSetter;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperBroker;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.FileUtils;

public class HAGraphDb
extends AbstractGraphDatabase
implements GraphDatabaseService,
ResponseReceiver {
    private final Map<String, String> config;
    private final BrokerFactory brokerFactory;
    private volatile Broker broker;
    private volatile EmbeddedGraphDbImpl localGraph;
    private final int machineId;
    private volatile MasterServer masterServer;
    private ScheduledExecutorService updatePuller;
    private volatile long updateTime = 0L;
    private volatile Throwable causeOfShutdown;
    private final long startupTime;
    private final BranchedDataPolicy branchedDataPolicy;
    private final HaConfig.SlaveUpdateMode slaveUpdateMode;
    private final int readTimeout;
    private volatile boolean pullUpdates;
    private final List<KernelEventHandler> kernelEventHandlers = new CopyOnWriteArrayList<KernelEventHandler>();
    private final Collection<TransactionEventHandler<?>> transactionEventHandlers = new CopyOnWriteArraySet();

    public HAGraphDb(String storeDir, Map<String, String> config) {
        this(storeDir, config, null);
    }

    public HAGraphDb(String storeDir, Map<String, String> config, BrokerFactory brokerFactory) {
        super(storeDir);
        if (config == null) {
            throw new IllegalArgumentException("null config, proper configuration required");
        }
        this.startupTime = System.currentTimeMillis();
        this.config = config;
        this.initializeTxManagerKernelPanicEventHandler();
        this.readTimeout = HaConfig.getClientReadTimeoutFromConfig(config);
        this.slaveUpdateMode = HaConfig.getSlaveUpdateModeFromConfig(config);
        this.machineId = HaConfig.getMachineIdFromConfig(config);
        this.branchedDataPolicy = HaConfig.getBranchedDataPolicyFromConfig(config);
        config.put("keep_logical_logs", "true");
        this.brokerFactory = brokerFactory != null ? brokerFactory : this.defaultBrokerFactory();
        this.broker = this.brokerFactory.create(this, config);
        this.pullUpdates = false;
        this.startUp(HaConfig.getAllowInitFromConfig(config));
    }

    private void initializeTxManagerKernelPanicEventHandler() {
        this.kernelEventHandlers.add(new KernelEventHandler(){

            public void beforeShutdown() {
            }

            public void kernelPanic(ErrorState error) {
                if (error == ErrorState.TX_MANAGER_NOT_OK) {
                    HAGraphDb.this.getMessageLog().logMessage("TxManager not ok, doing internal restart");
                    HAGraphDb.this.internalShutdown(true);
                    HAGraphDb.this.newMaster(new Exception("Tx manager not ok"));
                }
            }

            public Object getResource() {
                return null;
            }

            public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
                return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
            }
        });
    }

    private void getFreshDatabaseFromMaster() {
        Pair<Master, Machine> master = this.broker.getMasterReally(true);
        this.internalShutdown(false);
        this.makeWayForNewDb();
        Exception exception = null;
        for (int i = 0; i < 60; ++i) {
            try {
                this.copyStoreFromMaster(master);
                return;
            }
            catch (Exception e) {
                this.getMessageLog().logMessage("Problems copying store from master", (Throwable)e);
                this.sleepWithoutInterruption(1000L, "");
                exception = e;
                master = this.broker.getMasterReally(true);
                continue;
            }
        }
        throw new RuntimeException("Gave up trying to copy store from master", exception);
    }

    void makeWayForNewDb() {
        this.getMessageLog().logMessage("Cleaning database " + this.getStoreDir() + " (" + this.branchedDataPolicy.name() + ") to make way for new db from master");
        this.branchedDataPolicy.handle(this);
    }

    private synchronized void startUp(boolean allowInit) {
        StoreId storeId = null;
        if (!new File(this.getStoreDir(), "neostore").exists()) {
            long endTime = System.currentTimeMillis() + 60000L;
            Exception exception = null;
            while (System.currentTimeMillis() < endTime) {
                Pair<Master, Machine> master = this.broker.getMasterReally(true);
                if (master != null && !((Machine)master.other()).equals(Machine.NO_MACHINE) && ((Machine)master.other()).getMachineId() != this.machineId) {
                    try {
                        this.copyStoreFromMaster(master);
                        this.getMessageLog().logMessage("copied store from master");
                        exception = null;
                        break;
                    }
                    catch (Exception e) {
                        exception = e;
                        master = this.broker.getMasterReally(true);
                        this.getMessageLog().logMessage("Problems copying store from master", (Throwable)e);
                    }
                } else {
                    storeId = this.broker.getClusterStoreId();
                    break;
                }
                this.sleepWithoutInterruption(300L, "Startup interrupted");
            }
            if (exception != null) {
                throw new RuntimeException("Tried to join the cluster, but was unable to", exception);
            }
        }
        this.newMaster(storeId, new Exception("Starting up for the first time"));
        this.localGraph();
    }

    private void sleepWithoutInterruption(long time, String errorMessage) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStoreFromMaster(Pair<Master, Machine> master) throws Exception {
        this.getMessageLog().logMessage("Copying store from master");
        Response<Void> response = ((Master)master.first()).copyStore(new SlaveContext(0L, this.machineId, 0, new Pair[0]), (StoreWriter)new ToFileStoreWriter(this.getStoreDir()));
        long highestLogVersion = this.highestLogVersion();
        if (highestLogVersion > -1L) {
            NeoStore.setVersion((String)this.getStoreDir(), (long)(highestLogVersion + 1L));
        }
        EmbeddedGraphDatabase copiedDb = new EmbeddedGraphDatabase(this.getStoreDir(), MapUtil.stringMap((String[])new String[]{"keep_logical_logs", "true"}));
        try {
            MasterUtil.applyReceivedTransactions(response, (GraphDatabaseService)copiedDb, (MasterUtil.TxHandler)MasterUtil.txHandlerForFullCopy());
        }
        finally {
            copiedDb.shutdown();
        }
        this.getMessageLog().logMessage("Done copying store from master");
    }

    private long highestLogVersion() {
        return XaLogicalLog.getHighestHistoryLogVersion((File)new File(this.getStoreDir()), (String)"nioneo_logical.log");
    }

    private EmbeddedGraphDbImpl localGraph() {
        if (this.localGraph != null) {
            return this.localGraph;
        }
        int secondsWait = Math.max(HaConfig.getClientReadTimeoutFromConfig(this.config) - 5, 5);
        return this.waitForCondition(new LocalGraphAvailableCondition(), secondsWait * 1000);
    }

    private <T, E extends Exception> T waitForCondition(Condition<T, E> condition, int timeMillis) throws E {
        long endTime = System.currentTimeMillis() + (long)timeMillis;
        T result = condition.tryToFullfill();
        while (result == null && System.currentTimeMillis() < endTime) {
            this.sleepWithoutInterruption(1L, "Failed waiting for " + condition + " to be fulfilled");
            result = condition.tryToFullfill();
            if (result == null) continue;
            return result;
        }
        throw condition.failure();
    }

    private BrokerFactory defaultBrokerFactory() {
        return new BrokerFactory(){

            @Override
            public Broker create(AbstractGraphDatabase graphDb, Map<String, String> config) {
                return new ZooKeeperBroker(graphDb, config, HAGraphDb.this);
            }
        };
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void pullUpdates() {
        try {
            if (this.masterServer == null) {
                if (this.broker.getMaster() == null && this.broker instanceof ZooKeeperBroker) {
                    this.getMessageLog().logMessage("ZooKeeper broker returned null master");
                    this.newMaster(new NullPointerException("master returned from broker"));
                } else if (this.broker.getMaster().first() == null) {
                    this.newMaster(new NullPointerException("master returned from broker"));
                }
                this.receive(((Master)this.broker.getMaster().first()).pullUpdates(this.getSlaveContext(-1)));
            }
        }
        catch (ZooKeeperException e) {
            this.newMaster(e);
            throw e;
        }
        catch (ComException e) {
            this.newMaster((Exception)((Object)e));
            throw e;
        }
    }

    private void updateTime() {
        this.updateTime = System.currentTimeMillis();
    }

    long lastUpdateTime() {
        return this.updateTime;
    }

    public Config getConfig() {
        return this.localGraph().getConfig();
    }

    public <T> Collection<T> getManagementBeans(Class<T> type) {
        return this.localGraph().getManagementBeans(type);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getStoreDir() + ", " + "ha.server_id" + ":" + this.machineId + "]";
    }

    @Override
    public void reconnect(Exception e) {
        if (this.broker != null) {
            this.broker.shutdown();
        }
        this.broker = this.brokerFactory.create(this, this.config);
        this.newMaster(e);
    }

    protected synchronized void reevaluateMyself(StoreId storeId) {
        Pair<Master, Machine> master = this.broker.getMasterReally(true);
        boolean iAmCurrentlyMaster = this.masterServer != null;
        this.getMessageLog().logMessage("ReevaluateMyself: machineId=" + this.machineId + " with master[" + master + "] (I am master=" + iAmCurrentlyMaster + ", " + this.localGraph + ")");
        this.pullUpdates = false;
        EmbeddedGraphDbImpl newDb = null;
        try {
            if (((Machine)master.other()).getMachineId() == this.machineId) {
                if (this.localGraph == null || !iAmCurrentlyMaster) {
                    this.internalShutdown(true);
                    newDb = this.startAsMaster(storeId);
                }
                this.broker.rebindMaster();
            } else {
                this.broker.notifyMasterChange((Machine)master.other());
                if (this.localGraph == null || iAmCurrentlyMaster) {
                    this.internalShutdown(true);
                    newDb = this.startAsSlave(storeId, master);
                } else {
                    ((SlaveIdGenerator.SlaveIdGeneratorFactory)this.getConfig().getIdGeneratorFactory()).forgetIdAllocationsFromMaster();
                }
                this.ensureDataConsistencyWithMaster(newDb != null ? newDb : this.localGraph, master);
                this.getMessageLog().logMessage("Data consistent with master");
            }
            if (newDb != null) {
                this.doAfterLocalGraphStarted(newDb);
                this.localGraph = newDb;
                if (this.masterServer == null) {
                    this.instantiateAutoUpdatePullerIfConfigSaysSo();
                    this.pullUpdates = true;
                }
            }
        }
        catch (Throwable t) {
            this.safelyShutdownDb(newDb);
            throw Exceptions.launderedException((Throwable)t);
        }
    }

    private void safelyShutdownDb(EmbeddedGraphDbImpl newDb) {
        try {
            if (newDb != null) {
                newDb.shutdown();
            }
        }
        catch (Exception e) {
            this.getMessageLog().logMessage("Couldn't shut down newly started db", (Throwable)e);
        }
    }

    private void doAfterLocalGraphStarted(EmbeddedGraphDbImpl newDb) {
        this.broker.setConnectionInformation(newDb.getKernelData());
        for (TransactionEventHandler<?> transactionEventHandler : this.transactionEventHandlers) {
            newDb.registerTransactionEventHandler(transactionEventHandler);
        }
        for (KernelEventHandler kernelEventHandler : this.kernelEventHandlers) {
            newDb.registerKernelEventHandler(kernelEventHandler);
        }
    }

    private void logHaInfo(String started) {
        this.getMessageLog().logMessage(started, true);
        this.getMessageLog().logMessage("--- HIGH AVAILABILITY CONFIGURATION START ---");
        this.broker.logStatus(this.getMessageLog());
        this.getMessageLog().logMessage("--- HIGH AVAILABILITY CONFIGURATION END ---", true);
    }

    private EmbeddedGraphDbImpl startAsSlave(StoreId storeId, Pair<Master, Machine> master) {
        this.getMessageLog().logMessage("Starting[" + this.machineId + "] as slave", true);
        EmbeddedGraphDbImpl result = new EmbeddedGraphDbImpl(this.getStoreDir(), storeId, this.config, (AbstractGraphDatabase)this, (LockManagerFactory)new SlaveLockManager.SlaveLockManagerFactory(this.broker, this), (IdGeneratorFactory)new SlaveIdGenerator.SlaveIdGeneratorFactory(this.broker, this), (RelationshipTypeCreator)new SlaveRelationshipTypeCreator(this.broker, this), (TxIdGeneratorFactory)new SlaveTxIdGenerator.SlaveTxIdGeneratorFactory(this.broker, this), (TxHook)new SlaveTxHook(this.broker, this), this.slaveUpdateMode.createUpdater(this.broker), CommonFactories.defaultFileSystemAbstraction());
        this.logHaInfo("Started as slave");
        return result;
    }

    private EmbeddedGraphDbImpl startAsMaster(StoreId storeId) {
        this.getMessageLog().logMessage("Starting[" + this.machineId + "] as master", true);
        EmbeddedGraphDbImpl result = new EmbeddedGraphDbImpl(this.getStoreDir(), storeId, this.config, (AbstractGraphDatabase)this, CommonFactories.defaultLockManagerFactory(), (IdGeneratorFactory)new MasterIdGeneratorFactory(), CommonFactories.defaultRelationshipTypeCreator(), (TxIdGeneratorFactory)new MasterTxIdGenerator.MasterTxIdGeneratorFactory(this.broker), (TxHook)new MasterTxHook(), (LastCommittedTxIdSetter)new ZooKeeperLastCommittedTxIdSetter(this.broker), CommonFactories.defaultFileSystemAbstraction());
        this.masterServer = (MasterServer)((Object)this.broker.instantiateMasterServer(this));
        this.logHaInfo("Started as master");
        return result;
    }

    private void ensureDataConsistencyWithMaster(EmbeddedGraphDbImpl newDb, Pair<Master, Machine> master) {
        Pair myMaster;
        if (((Machine)master.other()).getMachineId() == this.machineId) {
            this.getMessageLog().logMessage("I am master so cannot consistency check data with master");
            return;
        }
        if (master.first() == null) {
            RuntimeException cause = new RuntimeException("Unable to get master from ZK");
            this.shutdown(cause, false);
            throw cause;
        }
        XaDataSource nioneoDataSource = newDb.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
        long myLastCommittedTx = nioneoDataSource.getLastCommittedTxId();
        try {
            myMaster = nioneoDataSource.getMasterForCommittedTx(myLastCommittedTx);
        }
        catch (NoSuchLogVersionException e) {
            this.getMessageLog().logMessage("Logical log file for txId " + myLastCommittedTx + " not found, perhaps due to the db being copied from master. Ignoring.");
            return;
        }
        catch (IOException e) {
            this.getMessageLog().logMessage("Failed to get master ID for txId " + myLastCommittedTx + ".", (Throwable)e);
            return;
        }
        catch (Exception e) {
            throw new BranchedDataException("Maybe not branched data, but it could solve it", e);
        }
        long endTime = System.currentTimeMillis() + (long)(this.readTimeout * 1000);
        Pair mastersMaster = null;
        ComException failure = null;
        while (mastersMaster == null && System.currentTimeMillis() < endTime) {
            try {
                mastersMaster = (Pair)((Master)master.first()).getMasterIdForCommittedTx(myLastCommittedTx, this.getStoreId(newDb)).response();
            }
            catch (ComException e) {
                failure = e;
                this.sleepWithoutInterruption(500L, "Failed waiting for next attempt to contact master");
            }
        }
        if (mastersMaster == null) {
            throw failure;
        }
        if ((Integer)myMaster.first() != -1 && !myMaster.equals(mastersMaster)) {
            String msg = "Branched data, I (machineId:" + this.machineId + ") think machineId for txId (" + myLastCommittedTx + ") is " + myMaster + ", but master (machineId:" + ((Machine)master.other()).getMachineId() + ") says that it's " + mastersMaster;
            this.getMessageLog().logMessage(msg, true);
            BranchedDataException exception = new BranchedDataException(msg);
            this.safelyShutdownDb(newDb);
            this.shutdown(exception, false);
            throw exception;
        }
        this.getMessageLog().logMessage("Master id for last committed tx ok with highestTxId=" + myLastCommittedTx + " with masterId=" + myMaster, true);
    }

    private StoreId getStoreId(EmbeddedGraphDbImpl db) {
        XaDataSource ds = db.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
        return ((NeoStoreXaDataSource)ds).getStoreId();
    }

    private void instantiateAutoUpdatePullerIfConfigSaysSo() {
        long pullInterval = HaConfig.getPullIntervalFromConfig(this.config);
        if (pullInterval > 0L) {
            this.updatePuller = new ScheduledThreadPoolExecutor(1);
            this.updatePuller.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (HAGraphDb.this.pullUpdates) {
                            HAGraphDb.this.pullUpdates();
                        }
                    }
                    catch (Exception e) {
                        HAGraphDb.this.getMessageLog().logMessage("Pull updates failed", (Throwable)e);
                    }
                }
            }, pullInterval, pullInterval, TimeUnit.MILLISECONDS);
        }
    }

    public TransactionBuilder tx() {
        return this.localGraph().tx();
    }

    public Node createNode() {
        return this.localGraph().createNode();
    }

    public Node getNodeById(long id) {
        return this.localGraph().getNodeById(id);
    }

    public Node getReferenceNode() {
        return this.localGraph().getReferenceNode();
    }

    public Relationship getRelationshipById(long id) {
        return this.localGraph().getRelationshipById(id);
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        this.kernelEventHandlers.add(handler);
        return this.localGraph().registerKernelEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.transactionEventHandlers.add(handler);
        return this.localGraph().registerTransactionEventHandler(handler);
    }

    public synchronized void internalShutdown(boolean rotateLogs) {
        this.getMessageLog().logMessage("Internal shutdown of HA db[" + this.machineId + "] reference=" + this + ", masterServer=" + (Object)((Object)this.masterServer), (Throwable)new Exception("Internal shutdown"), true);
        this.pullUpdates = false;
        if (this.updatePuller != null) {
            this.getMessageLog().logMessage("Internal shutdown updatePuller", true);
            try {
                this.updatePuller.shutdown();
                this.updatePuller.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.getMessageLog().logMessage("Got exception while waiting for update puller termination", (Throwable)e, true);
            }
            this.getMessageLog().logMessage("Internal shutdown updatePuller DONE", true);
            this.updatePuller = null;
        }
        if (this.masterServer != null) {
            this.getMessageLog().logMessage("Internal shutdown masterServer", true);
            this.masterServer.shutdown();
            this.getMessageLog().logMessage("Internal shutdown masterServer DONE", true);
            this.masterServer = null;
        }
        if (this.localGraph != null) {
            if (rotateLogs) {
                for (XaDataSource dataSource : this.getConfig().getTxModule().getXaDataSourceManager().getAllRegisteredDataSources()) {
                    try {
                        dataSource.rotateLogicalLog();
                    }
                    catch (IOException e) {
                        this.getMessageLog().logMessage("Couldn't rotate logical log for " + dataSource.getName(), (Throwable)e);
                    }
                }
            }
            this.getMessageLog().logMessage("Internal shutdown localGraph", true);
            this.localGraph.shutdown();
            this.getMessageLog().logMessage("Internal shutdown localGraph DONE", true);
            this.localGraph = null;
        }
        this.getMessageLog().flush();
    }

    private synchronized void shutdown(Throwable cause, boolean shutdownBroker) {
        this.causeOfShutdown = cause;
        this.getMessageLog().logMessage("Shutdown[" + this.machineId + "], " + this, true);
        if (shutdownBroker && this.broker != null) {
            this.broker.shutdown();
        }
        this.internalShutdown(false);
    }

    protected synchronized void close() {
        this.shutdown(new IllegalStateException("shutdown called"), true);
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.localGraph().unregisterKernelEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.localGraph().unregisterTransactionEventHandler(handler);
    }

    @Override
    public SlaveContext getSlaveContext(int eventIdentifier) {
        XaDataSourceManager localDataSourceManager = this.getConfig().getTxModule().getXaDataSourceManager();
        Collection dataSources = localDataSourceManager.getAllRegisteredDataSources();
        Pair[] txs = new Pair[dataSources.size()];
        int i = 0;
        for (XaDataSource dataSource : dataSources) {
            txs[i++] = Pair.of((Object)dataSource.getName(), (Object)dataSource.getLastCommittedTxId());
        }
        return new SlaveContext(this.startupTime, this.machineId, eventIdentifier, txs);
    }

    @Override
    public <T> T receive(Response<T> response) {
        try {
            MasterUtil.applyReceivedTransactions(response, (GraphDatabaseService)this, (MasterUtil.TxHandler)MasterUtil.NO_ACTION);
            this.updateTime();
            return (T)response.response();
        }
        catch (IOException e) {
            this.newMaster(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void newMaster(Exception e) {
        this.newMaster(null, e);
    }

    private synchronized void newMaster(StoreId storeId, Exception e) {
        try {
            this.doNewMaster(storeId, e);
        }
        catch (BranchedDataException bde) {
            this.getMessageLog().logMessage("Branched data occured, retrying");
            this.getFreshDatabaseFromMaster();
            this.doNewMaster(storeId, bde);
        }
    }

    private void doNewMaster(StoreId storeId, Exception e) {
        try {
            this.getMessageLog().logMessage("newMaster called", true);
            this.reevaluateMyself(storeId);
        }
        catch (ZooKeeperException ee) {
            this.getMessageLog().logMessage("ZooKeeper exception in newMaster", (Throwable)ee);
            throw Exceptions.launderedException((Throwable)ee);
        }
        catch (ComException ee) {
            this.getMessageLog().logMessage("Communication exception in newMaster", (Throwable)ee);
            throw Exceptions.launderedException((Throwable)ee);
        }
        catch (BranchedDataException ee) {
            throw ee;
        }
        catch (Throwable t) {
            this.getMessageLog().logMessage("Reevaluation ended in unknown exception " + t + " so shutting down", t, true);
            this.shutdown(t, false);
            throw Exceptions.launderedException((Throwable)t);
        }
    }

    public MasterServer getMasterServerIfMaster() {
        return this.masterServer;
    }

    int getMachineId() {
        return this.machineId;
    }

    public boolean isMaster() {
        return this.broker.iAmMaster();
    }

    public IndexManager index() {
        return this.localGraph().index();
    }

    public void shutdownBroker() {
        this.broker.shutdown();
    }

    public KernelData getKernelData() {
        return this.localGraph().getKernelData();
    }

    private class LocalGraphAvailableCondition
    implements Condition<EmbeddedGraphDbImpl, RuntimeException> {
        private LocalGraphAvailableCondition() {
        }

        @Override
        public EmbeddedGraphDbImpl tryToFullfill() {
            return HAGraphDb.this.localGraph;
        }

        @Override
        public RuntimeException failure() {
            if (HAGraphDb.this.causeOfShutdown != null) {
                return new RuntimeException("Graph database not started", HAGraphDb.this.causeOfShutdown);
            }
            return new RuntimeException("Graph database not assigned and no cause of shutdown, maybe not started yet or in the middle of master/slave swap?");
        }
    }

    private static interface Condition<T, E extends Exception> {
        public T tryToFullfill();

        public E failure();
    }

    static enum BranchedDataPolicy {
        keep_all{

            @Override
            void handle(HAGraphDb db) {
                this.moveAwayDb(db, this.branchedDataDir(db));
            }
        }
        ,
        keep_last{

            @Override
            void handle(HAGraphDb db) {
                File branchedDataDir = this.branchedDataDir(db);
                this.moveAwayDb(db, branchedDataDir);
                for (File file : new File(db.getStoreDir()).listFiles()) {
                    if (!this.isBranchedDataDirectory(file) || file.equals(branchedDataDir)) continue;
                    try {
                        FileUtils.deleteRecursively((File)file);
                    }
                    catch (IOException e) {
                        db.getMessageLog().logMessage("Couldn't delete old branched data directory " + file, (Throwable)e);
                    }
                }
            }
        }
        ,
        keep_none{

            @Override
            void handle(HAGraphDb db) {
                for (File file : this.relevantDbFiles(db)) {
                    try {
                        FileUtils.deleteRecursively((File)file);
                    }
                    catch (IOException e) {
                        db.getMessageLog().logMessage("Couldn't delete file " + file, (Throwable)e);
                    }
                }
            }
        }
        ,
        shutdown{

            @Override
            void handle(HAGraphDb db) {
                db.shutdown();
            }
        };

        static String BRANCH_PREFIX;

        abstract void handle(HAGraphDb var1);

        protected void moveAwayDb(HAGraphDb db, File branchedDataDir) {
            for (File file : this.relevantDbFiles(db)) {
                File dest = new File(branchedDataDir, file.getName());
                if (file.renameTo(dest)) continue;
                db.getMessageLog().logMessage("Couldn't move " + file.getPath());
            }
        }

        File branchedDataDir(HAGraphDb db) {
            File result = new File(db.getStoreDir(), BRANCH_PREFIX + System.currentTimeMillis());
            result.mkdirs();
            return result;
        }

        File[] relevantDbFiles(HAGraphDb db) {
            return new File(db.getStoreDir()).listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.getName().equals("messages.log") && !BranchedDataPolicy.this.isBranchedDataDirectory(file);
                }
            });
        }

        boolean isBranchedDataDirectory(File file) {
            return file.isDirectory() && file.getName().startsWith(BRANCH_PREFIX);
        }

        static {
            BRANCH_PREFIX = "branched-";
        }
    }
}

