/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.HaConfig;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;

public class FakeMasterBroker
extends AbstractBroker {
    private Map<String, String> config;
    private StoreId storeId = new StoreId();

    public FakeMasterBroker(int myMachineId, GraphDatabaseService graphDb, Map<String, String> config) {
        super(myMachineId, graphDb);
        this.config = config;
    }

    @Override
    public StoreId getClusterStoreId() {
        return this.storeId;
    }

    public Machine getMasterMachine() {
        return new Machine(this.getMyMachineId(), 0, 1L, -1, null);
    }

    @Override
    public Pair<Master, Machine> getMaster() {
        return Pair.of(null, (Object)new Machine(this.getMyMachineId(), 0, 1L, -1, null));
    }

    @Override
    public Pair<Master, Machine> getMasterReally(boolean allowChange) {
        return Pair.of(null, (Object)new Machine(this.getMyMachineId(), 0, 1L, -1, null));
    }

    @Override
    public boolean iAmMaster() {
        return this.getMyMachineId() == 0;
    }

    @Override
    public Object instantiateMasterServer(AbstractGraphDatabase graphDb) {
        return new MasterServer(new MasterImpl((GraphDatabaseService)graphDb, this.config), 8901, graphDb.getMessageLog(), HaConfig.getClientLockReadTimeoutFromConfig(this.config));
    }
}

