/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.BlockLogBuffer;
import org.neo4j.com.BlockLogReader;
import org.neo4j.com.Client;
import org.neo4j.com.Deserializer;
import org.neo4j.com.MasterCaller;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.ToNetworkStoreWriter;
import org.neo4j.com.TxExtractor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.LockStatus;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.impl.nioneo.store.IdRange;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;

public class MasterClient
extends Client<Master>
implements Master {
    static final ObjectSerializer<LockResult> LOCK_SERIALIZER = new ObjectSerializer<LockResult>(){

        public void write(LockResult responseObject, ChannelBuffer result) throws IOException {
            result.writeByte(responseObject.getStatus().ordinal());
            if (responseObject.getStatus().hasMessage()) {
                Protocol.writeString((ChannelBuffer)result, (String)responseObject.getDeadlockMessage());
            }
        }
    };
    protected static final Deserializer<LockResult> LOCK_RESULT_DESERIALIZER = new Deserializer<LockResult>(){

        public LockResult read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            LockStatus status = LockStatus.values()[buffer.readByte()];
            return status.hasMessage() ? new LockResult(Protocol.readString((ChannelBuffer)buffer)) : new LockResult(status);
        }
    };
    private final int lockReadTimeout;

    public MasterClient(String hostNameOrIp, int port, AbstractGraphDatabase graphDb, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels) {
        super(hostNameOrIp, port, graphDb.getMessageLog(), Client.storeIdGetterForDb((GraphDatabaseService)graphDb), 0x1000000, (byte)1, readTimeoutSeconds, maxConcurrentChannels, Math.min(maxConcurrentChannels, 20));
        this.lockReadTimeout = lockReadTimeout;
    }

    protected int getReadTimeout(RequestType<Master> type, int readTimeout) {
        return ((HaRequestType)type).isLock() ? this.lockReadTimeout : readTimeout;
    }

    protected boolean shouldCheckStoreId(RequestType<Master> type) {
        return type != HaRequestType.COPY_STORE;
    }

    @Override
    public Response<IdAllocation> allocateIds(final IdType idType) {
        return this.sendRequest(HaRequestType.ALLOCATE_IDS, SlaveContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                buffer.writeByte(idType.ordinal());
            }
        }, (Deserializer)new Deserializer<IdAllocation>(){

            public IdAllocation read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return MasterClient.readIdAllocation(buffer);
            }
        });
    }

    @Override
    public Response<Integer> createRelationshipType(SlaveContext context, final String name) {
        return this.sendRequest(HaRequestType.CREATE_RELATIONSHIP_TYPE, context, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Void> initializeTx(SlaveContext context) {
        return this.sendRequest(HaRequestType.INITIALIZE_TX, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireNodeWriteLock(SlaveContext context, long ... nodes) {
        return this.sendRequest(HaRequestType.ACQUIRE_NODE_WRITE_LOCK, context, new AcquireLockSerializer(nodes), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireNodeReadLock(SlaveContext context, long ... nodes) {
        return this.sendRequest(HaRequestType.ACQUIRE_NODE_READ_LOCK, context, new AcquireLockSerializer(nodes), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireRelationshipWriteLock(SlaveContext context, long ... relationships) {
        return this.sendRequest(HaRequestType.ACQUIRE_RELATIONSHIP_WRITE_LOCK, context, new AcquireLockSerializer(relationships), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireRelationshipReadLock(SlaveContext context, long ... relationships) {
        return this.sendRequest(HaRequestType.ACQUIRE_RELATIONSHIP_READ_LOCK, context, new AcquireLockSerializer(relationships), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireGraphWriteLock(SlaveContext context) {
        return this.sendRequest(HaRequestType.ACQUIRE_GRAPH_WRITE_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireGraphReadLock(SlaveContext context) {
        return this.sendRequest(HaRequestType.ACQUIRE_GRAPH_READ_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireIndexReadLock(SlaveContext context, String index, String key) {
        return this.sendRequest(HaRequestType.ACQUIRE_INDEX_READ_LOCK, context, new AcquireIndexLockSerializer(index, key), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireIndexWriteLock(SlaveContext context, String index, String key) {
        return this.sendRequest(HaRequestType.ACQUIRE_INDEX_WRITE_LOCK, context, new AcquireIndexLockSerializer(index, key), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<Long> commitSingleResourceTransaction(SlaveContext context, final String resource, final TxExtractor txGetter) {
        return this.sendRequest(HaRequestType.COMMIT, context, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)resource);
                BlockLogBuffer blockLogBuffer = new BlockLogBuffer(buffer);
                txGetter.extract((LogBuffer)blockLogBuffer);
                blockLogBuffer.done();
            }
        }, (Deserializer)new Deserializer<Long>(){

            public Long read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readLong();
            }
        });
    }

    @Override
    public Response<Void> finishTransaction(SlaveContext context, final boolean success) {
        return this.sendRequest(HaRequestType.FINISH, context, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                buffer.writeByte(success ? 1 : 0);
            }
        }, Protocol.VOID_DESERIALIZER);
    }

    public void rollbackOngoingTransactions(SlaveContext context) {
        throw new UnsupportedOperationException("Should never be called from the client side");
    }

    @Override
    public Response<Void> pullUpdates(SlaveContext context) {
        return this.sendRequest(HaRequestType.PULL_UPDATES, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<Pair<Integer, Long>> getMasterIdForCommittedTx(final long txId, StoreId storeId) {
        return this.sendRequest(HaRequestType.GET_MASTER_ID_FOR_TX, SlaveContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                buffer.writeLong(txId);
            }
        }, (Deserializer)new Deserializer<Pair<Integer, Long>>(){

            public Pair<Integer, Long> read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return Pair.of((Object)buffer.readInt(), (Object)buffer.readLong());
            }
        }, storeId);
    }

    @Override
    public Response<Void> copyStore(SlaveContext context, StoreWriter writer) {
        context = new SlaveContext(context.getSessionId(), context.machineId(), context.getEventIdentifier(), new Pair[0]);
        return this.sendRequest(HaRequestType.COPY_STORE, context, Protocol.EMPTY_SERIALIZER, (Deserializer)new Protocol.FileStreamsDeserializer(writer));
    }

    protected static IdAllocation readIdAllocation(ChannelBuffer buffer) {
        int numberOfDefragIds = buffer.readInt();
        long[] defragIds = new long[numberOfDefragIds];
        for (int i = 0; i < numberOfDefragIds; ++i) {
            defragIds[i] = buffer.readLong();
        }
        long rangeStart = buffer.readLong();
        int rangeLength = buffer.readInt();
        long highId = buffer.readLong();
        long defragCount = buffer.readLong();
        return new IdAllocation(new IdRange(defragIds, rangeStart, rangeLength), highId, defragCount);
    }

    static abstract class AquireLockCall
    implements MasterCaller<Master, LockResult> {
        AquireLockCall() {
        }

        public Response<LockResult> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
            long[] ids = new long[input.readInt()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = input.readLong();
            }
            return this.lock(master, context, ids);
        }

        abstract Response<LockResult> lock(Master var1, SlaveContext var2, long ... var3);
    }

    protected static class AcquireIndexLockSerializer
    implements Serializer {
        private final String index;
        private final String key;

        AcquireIndexLockSerializer(String index, String key) {
            this.index = index;
            this.key = key;
        }

        public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
            Protocol.writeString((ChannelBuffer)buffer, (String)this.index);
            Protocol.writeString((ChannelBuffer)buffer, (String)this.key);
        }
    }

    protected static class AcquireLockSerializer
    implements Serializer {
        private final long[] entities;

        AcquireLockSerializer(long ... entities) {
            this.entities = entities;
        }

        public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
            buffer.writeInt(this.entities.length);
            for (long entity : this.entities) {
                buffer.writeLong(entity);
            }
        }
    }

    public static enum HaRequestType implements RequestType<Master>
    {
        ALLOCATE_IDS((MasterCaller)new MasterCaller<Master, IdAllocation>(){

            public Response<IdAllocation> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                IdType idType = IdType.values()[input.readByte()];
                return master.allocateIds(idType);
            }
        }, new ObjectSerializer<IdAllocation>(){

            public void write(IdAllocation idAllocation, ChannelBuffer result) throws IOException {
                IdRange idRange = idAllocation.getIdRange();
                result.writeInt(idRange.getDefragIds().length);
                for (long id : idRange.getDefragIds()) {
                    result.writeLong(id);
                }
                result.writeLong(idRange.getRangeStart());
                result.writeInt(idRange.getRangeLength());
                result.writeLong(idAllocation.getHighestIdInUse());
                result.writeLong(idAllocation.getDefragCount());
            }
        }, false),
        CREATE_RELATIONSHIP_TYPE((MasterCaller)new MasterCaller<Master, Integer>(){

            public Response<Integer> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.createRelationshipType(context, Protocol.readString((ChannelBuffer)input));
            }
        }, Protocol.INTEGER_SERIALIZER, true),
        ACQUIRE_NODE_WRITE_LOCK((MasterCaller)new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireNodeWriteLock(context, ids);
            }
        }, (ObjectSerializer)LOCK_SERIALIZER, true){

            @Override
            public boolean isLock() {
                return true;
            }
        }
        ,
        ACQUIRE_NODE_READ_LOCK((MasterCaller)new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireNodeReadLock(context, ids);
            }
        }, (ObjectSerializer)LOCK_SERIALIZER, true){

            @Override
            public boolean isLock() {
                return true;
            }
        }
        ,
        ACQUIRE_RELATIONSHIP_WRITE_LOCK((MasterCaller)new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireRelationshipWriteLock(context, ids);
            }
        }, (ObjectSerializer)LOCK_SERIALIZER, true){

            @Override
            public boolean isLock() {
                return true;
            }
        }
        ,
        ACQUIRE_RELATIONSHIP_READ_LOCK((MasterCaller)new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireRelationshipReadLock(context, ids);
            }
        }, (ObjectSerializer)LOCK_SERIALIZER, true){

            @Override
            public boolean isLock() {
                return true;
            }
        }
        ,
        COMMIT((MasterCaller)new MasterCaller<Master, Long>(){

            public Response<Long> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                String resource = Protocol.readString((ChannelBuffer)input);
                BlockLogReader reader = new BlockLogReader(input);
                return master.commitSingleResourceTransaction(context, resource, TxExtractor.create((ReadableByteChannel)reader));
            }
        }, Protocol.LONG_SERIALIZER, true),
        PULL_UPDATES((MasterCaller)new MasterCaller<Master, Void>(){

            public Response<Void> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.pullUpdates(context);
            }
        }, Protocol.VOID_SERIALIZER, true),
        FINISH((MasterCaller)new MasterCaller<Master, Void>(){

            public Response<Void> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.finishTransaction(context, Protocol.readBoolean((ChannelBuffer)input));
            }
        }, Protocol.VOID_SERIALIZER, true),
        GET_MASTER_ID_FOR_TX((MasterCaller)new MasterCaller<Master, Pair<Integer, Long>>(){

            public Response<Pair<Integer, Long>> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.getMasterIdForCommittedTx(input.readLong(), null);
            }
        }, new ObjectSerializer<Pair<Integer, Long>>(){

            public void write(Pair<Integer, Long> responseObject, ChannelBuffer result) throws IOException {
                result.writeInt(((Integer)responseObject.first()).intValue());
                result.writeLong(((Long)responseObject.other()).longValue());
            }
        }, false),
        COPY_STORE((MasterCaller)new MasterCaller<Master, Void>(){

            public Response<Void> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.copyStore(context, (StoreWriter)new ToNetworkStoreWriter(target));
            }
        }, Protocol.VOID_SERIALIZER, true),
        INITIALIZE_TX((MasterCaller)new MasterCaller<Master, Void>(){

            public Response<Void> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.initializeTx(context);
            }
        }, Protocol.VOID_SERIALIZER, true),
        ACQUIRE_GRAPH_WRITE_LOCK((MasterCaller)new MasterCaller<Master, LockResult>(){

            public Response<LockResult> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.acquireGraphWriteLock(context);
            }
        }, (ObjectSerializer)LOCK_SERIALIZER, true){

            @Override
            public boolean isLock() {
                return true;
            }
        }
        ,
        ACQUIRE_GRAPH_READ_LOCK((MasterCaller)new MasterCaller<Master, LockResult>(){

            public Response<LockResult> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.acquireGraphReadLock(context);
            }
        }, (ObjectSerializer)LOCK_SERIALIZER, true){

            @Override
            public boolean isLock() {
                return true;
            }
        }
        ,
        ACQUIRE_INDEX_READ_LOCK((MasterCaller)new MasterCaller<Master, LockResult>(){

            public Response<LockResult> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.acquireIndexReadLock(context, Protocol.readString((ChannelBuffer)input), Protocol.readString((ChannelBuffer)input));
            }
        }, (ObjectSerializer)LOCK_SERIALIZER, true){

            @Override
            public boolean isLock() {
                return true;
            }
        }
        ,
        ACQUIRE_INDEX_WRITE_LOCK((MasterCaller)new MasterCaller<Master, LockResult>(){

            public Response<LockResult> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.acquireIndexWriteLock(context, Protocol.readString((ChannelBuffer)input), Protocol.readString((ChannelBuffer)input));
            }
        }, (ObjectSerializer)LOCK_SERIALIZER, true){

            @Override
            public boolean isLock() {
                return true;
            }
        };

        final MasterCaller caller;
        final ObjectSerializer serializer;
        private final boolean includesSlaveContext;

        private <T> HaRequestType(MasterCaller caller, ObjectSerializer<T> serializer, boolean includesSlaveContext) {
            this.caller = caller;
            this.serializer = serializer;
            this.includesSlaveContext = includesSlaveContext;
        }

        protected int timeoutForLocking(int defaultTimeout) {
            return 0;
        }

        public ObjectSerializer getObjectSerializer() {
            return this.serializer;
        }

        public MasterCaller getMasterCaller() {
            return this.caller;
        }

        public byte id() {
            return (byte)this.ordinal();
        }

        public boolean includesSlaveContext() {
            return this.includesSlaveContext;
        }

        public boolean isLock() {
            return false;
        }
    }
}

