/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import javax.transaction.TransactionManager;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class MasterTxIdGenerator
implements TxIdGenerator {
    private final Broker broker;

    public MasterTxIdGenerator(Broker broker) {
        this.broker = broker;
    }

    public long generate(XaDataSource dataSource, int identifier) {
        return TxIdGenerator.DEFAULT.generate(dataSource, identifier);
    }

    public int getCurrentMasterId() {
        return this.broker.getMyMachineId();
    }

    public int getMyId() {
        return this.broker.getMyMachineId();
    }

    public static class MasterTxIdGeneratorFactory
    implements TxIdGeneratorFactory {
        private final Broker broker;

        public MasterTxIdGeneratorFactory(Broker broker) {
            this.broker = broker;
        }

        public TxIdGenerator create(TransactionManager txManager) {
            return new MasterTxIdGenerator(this.broker);
        }
    }
}

