/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.transaction.TransactionManager;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.TxExtractor;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class SlaveTxIdGenerator
implements TxIdGenerator {
    private final Broker broker;
    private final SlaveDatabaseOperations databaseOperations;
    private final TxManager txManager;

    public SlaveTxIdGenerator(Broker broker, SlaveDatabaseOperations databaseOperations, TransactionManager txManager) {
        this.broker = broker;
        this.databaseOperations = databaseOperations;
        this.txManager = (TxManager)txManager;
    }

    public long generate(final XaDataSource dataSource, final int identifier) {
        try {
            int eventIdentifier = this.txManager.getEventIdentifier();
            Response<Long> response = ((Master)this.broker.getMaster().first()).commitSingleResourceTransaction(this.onlyForThisDataSource(this.databaseOperations.getSlaveContext(eventIdentifier), dataSource), dataSource.getName(), new TxExtractor(){

                public void extract(LogBuffer buffer) {
                    try {
                        dataSource.getPreparedTransaction(identifier, buffer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public ReadableByteChannel extract() {
                    try {
                        return dataSource.getPreparedTransaction(identifier);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return this.databaseOperations.receive(response);
        }
        catch (RuntimeException e) {
            this.databaseOperations.exceptionHappened(e);
            throw e;
        }
    }

    private SlaveContext onlyForThisDataSource(SlaveContext slaveContext, XaDataSource dataSource) {
        SlaveContext.Tx txForDs = null;
        for (SlaveContext.Tx tx : slaveContext.lastAppliedTransactions()) {
            if (!tx.getDataSourceName().equals(dataSource.getName())) continue;
            txForDs = tx;
            break;
        }
        if (txForDs == null) {
            throw new RuntimeException("Apparently " + slaveContext + " didn't have the XA data source we are commiting (" + dataSource.getName() + ")");
        }
        return new SlaveContext(slaveContext.getSessionId(), slaveContext.machineId(), slaveContext.getEventIdentifier(), new SlaveContext.Tx[]{txForDs}, slaveContext.getMasterId(), slaveContext.getChecksum());
    }

    public int getCurrentMasterId() {
        return ((Machine)this.broker.getMaster().other()).getMachineId();
    }

    public int getMyId() {
        return this.broker.getMyMachineId();
    }

    public static class SlaveTxIdGeneratorFactory
    implements TxIdGeneratorFactory {
        private final Broker broker;
        private final SlaveDatabaseOperations databaseOperations;

        public SlaveTxIdGeneratorFactory(Broker broker, SlaveDatabaseOperations databaseOperations) {
            this.broker = broker;
            this.databaseOperations = databaseOperations;
        }

        public TxIdGenerator create(TransactionManager txManager) {
            return new SlaveTxIdGenerator(this.broker, this.databaseOperations, txManager);
        }
    }
}

