/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.management.remote.JMXServiceURL;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.com.StoreIdGetter;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InformativeStackTrace;
import org.neo4j.kernel.SlaveUpdateMode;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.ClusterEventReceiver;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.ha.zookeeper.AbstractZooKeeperManager;
import org.neo4j.kernel.ha.zookeeper.BranchDetectingTxVerifier;
import org.neo4j.kernel.ha.zookeeper.BrokerShutDownException;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.NeoStoreUtil;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperMachine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperTimedOutException;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.NullLogBuffer;
import org.neo4j.kernel.impl.util.StringLogger;

public class ZooClient
extends AbstractZooKeeperManager {
    static final String MASTER_NOTIFY_CHILD = "master-notify";
    static final String MASTER_REBOUND_CHILD = "master-rebound";
    private final ZooKeeper zooKeeper;
    private final int machineId;
    private String sequenceNr;
    private long committedTx;
    private int masterForCommittedTx;
    private final Object keeperStateMonitor = new Object();
    private volatile Watcher.Event.KeeperState keeperState = Watcher.Event.KeeperState.Disconnected;
    private volatile boolean shutdown = false;
    private String rootPath;
    private volatile StoreId storeId;
    private final String haServer;
    private final String storeDir;
    private long sessionId = -1L;
    private Config conf;
    private final SlaveDatabaseOperations localDatabase;
    private final ClusterEventReceiver clusterReceiver;
    private final int backupPort;
    private final boolean writeLastCommittedTx;
    private final String clusterName;
    private final boolean allowCreateCluster;

    public ZooClient(String storeDir, StringLogger stringLogger, StoreIdGetter storeIdGetter, Config conf, SlaveDatabaseOperations localDatabase, ClusterEventReceiver clusterReceiver) {
        super(conf.get((GraphDatabaseSetting)HaSettings.coordinators), storeIdGetter, stringLogger, conf.getInteger(HaSettings.read_timeout), conf.isSet((GraphDatabaseSetting)HaSettings.lock_read_timeout) ? conf.getInteger(HaSettings.lock_read_timeout) : conf.getInteger(HaSettings.read_timeout), conf.getInteger(HaSettings.max_concurrent_channels_per_slave), conf.getInteger(HaSettings.zk_session_timeout));
        this.storeDir = storeDir;
        this.conf = conf;
        this.localDatabase = localDatabase;
        this.clusterReceiver = clusterReceiver;
        this.machineId = conf.getInteger(HaSettings.server_id);
        this.backupPort = conf.getInteger((GraphDatabaseSetting.IntegerSetting)OnlineBackupSettings.online_backup_port);
        this.haServer = conf.isSet((GraphDatabaseSetting)HaSettings.server) ? conf.get((GraphDatabaseSetting)HaSettings.server) : this.defaultServer();
        this.writeLastCommittedTx = ((SlaveUpdateMode)conf.getEnum(SlaveUpdateMode.class, (GraphDatabaseSetting.OptionsSetting)HaSettings.slave_coordinator_update_mode)).syncWithZooKeeper;
        this.clusterName = conf.get((GraphDatabaseSetting)HaSettings.cluster_name);
        this.sequenceNr = "not initialized yet";
        this.allowCreateCluster = conf.getBoolean(HaSettings.allow_init_cluster);
        try {
            WatcherImpl watcher = new WatcherImpl();
            this.zooKeeper = new ZooKeeper(this.getServers(), this.getSessionTimeout(), (Watcher)watcher);
            watcher.flushUnprocessedEvents(this.zooKeeper);
        }
        catch (IOException e) {
            throw new ZooKeeperException("Unable to create zoo keeper client", e);
        }
    }

    private String defaultServer() {
        InetAddress host = null;
        try {
            host = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (host == null) {
            throw new IllegalStateException("Could not auto configure host name, please supply " + HaSettings.server.name());
        }
        return host.getHostAddress() + ":" + 6361;
    }

    public Object instantiateMasterServer(GraphDatabaseAPI graphDb) {
        int timeOut = this.conf.isSet((GraphDatabaseSetting)HaSettings.lock_read_timeout) ? this.conf.getInteger(HaSettings.lock_read_timeout) : this.conf.getInteger(HaSettings.read_timeout);
        return new MasterServer(new MasterImpl(graphDb, timeOut), (Integer)Machine.splitIpAndPort(this.haServer).other(), graphDb.getMessageLog(), this.conf.getInteger(HaSettings.max_concurrent_channels_per_slave), this.clientLockReadTimeout, new BranchDetectingTxVerifier(graphDb));
    }

    @Override
    protected int getMyMachineId() {
        return this.machineId;
    }

    private int toInt(byte[] data) {
        return ByteBuffer.wrap(data).getInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void waitForSyncConnected(AbstractZooKeeperManager.WaitMode mode) {
        long startTime;
        if (this.keeperState == Watcher.Event.KeeperState.SyncConnected) {
            return;
        }
        if (this.shutdown) {
            throw new ZooKeeperException("ZooKeeper client has been shutdwon");
        }
        AbstractZooKeeperManager.WaitStrategy strategy = mode.getStrategy(this);
        long currentTime = startTime = System.currentTimeMillis();
        Object object = this.keeperStateMonitor;
        synchronized (object) {
            do {
                try {
                    this.keeperStateMonitor.wait(250L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                if (this.keeperState == Watcher.Event.KeeperState.SyncConnected) {
                    return;
                }
                if (!this.shutdown) continue;
                throw new ZooKeeperException("ZooKeeper client has been shutdwon");
            } while (strategy.waitMore((currentTime = System.currentTimeMillis()) - startTime));
            if (this.keeperState != Watcher.Event.KeeperState.SyncConnected) {
                throw new ZooKeeperTimedOutException("Connection to ZooKeeper server timed out, keeper state=" + this.keeperState);
            }
        }
    }

    protected void subscribeToDataChangeWatcher(String child) {
        block8: {
            String root = this.getRoot();
            String path = root + "/" + child;
            try {
                try {
                    this.zooKeeper.getData(path, true, null);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) {
                        byte[] data = new byte[4];
                        ByteBuffer.wrap(data).putInt(-1);
                        try {
                            this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                            break block8;
                        }
                        catch (KeeperException ce) {
                            if (e.code() != KeeperException.Code.NODEEXISTS) {
                                throw new ZooKeeperException("Creation error", ce);
                            }
                            break block8;
                        }
                    }
                    throw new ZooKeeperException("Couldn't get or create " + child, e);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Interrupted", e);
            }
        }
    }

    protected void setDataChangeWatcher(String child, int currentMasterId) {
        try {
            boolean exists;
            byte[] data;
            String path;
            block11: {
                String root = this.getRoot();
                path = root + "/" + child;
                data = null;
                exists = false;
                try {
                    data = this.zooKeeper.getData(path, true, null);
                    exists = true;
                    if (ByteBuffer.wrap(data).getInt() == currentMasterId) {
                        this.msgLog.logMessage(child + " not set, is already " + currentMasterId);
                        return;
                    }
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) break block11;
                    throw new ZooKeeperException("Couldn't get master notify node", e);
                }
            }
            try {
                data = new byte[4];
                ByteBuffer.wrap(data).putInt(currentMasterId);
                if (!exists) {
                    this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    this.msgLog.logMessage(child + " created with " + currentMasterId);
                } else if (currentMasterId != -1) {
                    this.zooKeeper.setData(path, data, -1);
                    this.msgLog.logMessage(child + " set to " + currentMasterId);
                }
                this.zooKeeper.getData(path, true, null);
            }
            catch (KeeperException e) {
                if (e.code() != KeeperException.Code.NODEEXISTS) {
                    throw new ZooKeeperException("Couldn't set master notify node", e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    @Override
    public String getRoot() {
        this.makeSureRootPathIsFound();
        byte[] rootData = null;
        do {
            try {
                rootData = this.zooKeeper.getData(this.rootPath, false, null);
                return this.rootPath;
            }
            catch (KeeperException e) {
                if (e.code() != KeeperException.Code.NONODE) {
                    throw new ZooKeeperException("Unable to get root node", e);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Got interrupted", e);
            }
            try {
                byte[] data = new byte[]{};
                this.zooKeeper.create(this.rootPath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) continue;
                throw new ZooKeeperException("Unable to create root", e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Got interrupted", e);
            }
        } while (rootData == null);
        throw new IllegalStateException("Root path couldn't be found");
    }

    private void makeSureRootPathIsFound() {
        if (this.rootPath == null) {
            this.storeId = this.getClusterStoreId(this.zooKeeper, this.clusterName);
            if (this.storeId != null) {
                this.rootPath = this.asRootPath(this.storeId);
                if (NeoStoreUtil.storeExists(this.storeDir)) {
                    NeoStoreUtil store = new NeoStoreUtil(this.storeDir);
                    this.committedTx = store.getLastCommittedTx();
                    if (!this.storeId.equals((Object)store.asStoreId())) {
                        throw new ZooKeeperException("StoreId in database doesn't match that of the ZK cluster");
                    }
                } else {
                    this.committedTx = 1L;
                }
            } else {
                if (!this.allowCreateCluster) {
                    throw new RuntimeException("Not allowed to create cluster");
                }
                StoreId storeIdSuggestion = NeoStoreUtil.storeExists(this.storeDir) ? new NeoStoreUtil(this.storeDir).asStoreId() : new StoreId();
                this.storeId = this.createCluster(storeIdSuggestion);
                this.makeSureRootPathIsFound();
            }
            this.masterForCommittedTx = this.getFirstMasterForTx(this.committedTx);
        }
    }

    private void cleanupChildren() {
        try {
            String root = this.getRoot();
            List children = this.zooKeeper.getChildren(root, false);
            for (String child : children) {
                Pair<Integer, Integer> parsedChild = this.parseChild(child);
                if (parsedChild == null || (Integer)parsedChild.first() != this.machineId) continue;
                this.zooKeeper.delete(root + "/" + child, -1);
            }
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to clean up old child", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted.", e);
        }
    }

    private byte[] dataRepresentingMe(long txId, int master) {
        byte[] array = new byte[12];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putLong(txId);
        buffer.putInt(master);
        return array;
    }

    private String setup() {
        try {
            this.cleanupChildren();
            this.writeHaServerConfig();
            String root = this.getRoot();
            String path = root + "/" + this.machineId + "_";
            String created = this.zooKeeper.create(path, this.dataRepresentingMe(this.committedTx, this.masterForCommittedTx), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            this.subscribeToDataChangeWatcher(MASTER_NOTIFY_CHILD);
            this.subscribeToDataChangeWatcher(MASTER_REBOUND_CHILD);
            return created.substring(created.lastIndexOf("_") + 1);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to setup", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Setup got interrupted", e);
        }
        catch (Throwable t) {
            throw new ZooKeeperException("Unknown setup error", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHaServerConfig() throws InterruptedException, KeeperException {
        String path;
        block11: {
            path = this.rootPath + "/" + "ha-servers";
            try {
                this.zooKeeper.create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block11;
                throw e;
            }
        }
        String machinePath = path + "/" + this.machineId;
        byte[] data = this.haServerAsData();
        try {
            this.zooKeeper.create(machinePath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (KeeperException e) {
            if (e.code() != KeeperException.Code.NODEEXISTS) {
                throw e;
            }
            this.msgLog.logMessage("HA server info already present, trying again");
            try {
                this.zooKeeper.delete(machinePath, -1);
            }
            catch (KeeperException ee) {
                if (ee.code() != KeeperException.Code.NONODE) {
                    this.msgLog.logMessage("Unable to delete " + machinePath, (Throwable)ee);
                }
            }
            finally {
                this.writeHaServerConfig();
            }
        }
        this.zooKeeper.setData(machinePath, data, -1);
        this.msgLog.logMessage("Wrote HA server " + this.haServer + " to zoo keeper");
    }

    private byte[] haServerAsData() {
        byte[] array = new byte[this.haServer.length() * 2 + 100];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putInt(this.backupPort);
        buffer.put((byte)this.haServer.length());
        buffer.asCharBuffer().put(this.haServer.toCharArray()).flip();
        byte[] actualArray = new byte[buffer.limit()];
        System.arraycopy(array, 0, actualArray, 0, actualArray.length);
        return actualArray;
    }

    public synchronized void setJmxConnectionData(JMXServiceURL jmxUrl, String instanceId) {
        block7: {
            String path = this.rootPath + "/" + "ha-servers" + "/" + this.machineId + "-jmx";
            String url = jmxUrl.toString();
            byte[] data = new byte[(url.length() + instanceId.length()) * 2 + 4];
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.putShort((short)url.length());
            buffer.asCharBuffer().put(url.toCharArray());
            buffer.position(buffer.position() + url.length() * 2);
            buffer.putShort((short)instanceId.length());
            buffer.asCharBuffer().put(instanceId.toCharArray());
            if (buffer.limit() != data.length) {
                byte[] array = new byte[buffer.limit()];
                System.arraycopy(data, 0, array, 0, array.length);
                data = array;
            }
            try {
                try {
                    this.zooKeeper.setData(path, data, -1);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) {
                        this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                        break block7;
                    }
                    this.msgLog.logMessage("Unable to set jxm connection info", (Throwable)e);
                }
            }
            catch (KeeperException e) {
                this.msgLog.logMessage("Unable to set jxm connection info", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                this.msgLog.logMessage("Unable to set jxm connection info", (Throwable)e);
            }
        }
    }

    public void getJmxConnectionData(ConnectionInformation connection) {
        char[] instanceId;
        char[] url;
        byte[] data;
        String path = this.rootPath + "/" + "ha-servers" + "/" + this.machineId + "-jmx";
        try {
            data = this.zooKeeper.getData(path, false, null);
        }
        catch (KeeperException e) {
            return;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return;
        }
        if (data == null || data.length == 0) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        try {
            url = new char[buffer.getShort()];
            buffer.asCharBuffer().get(url);
            buffer.position(buffer.position() + url.length * 2);
            instanceId = new char[buffer.getShort()];
            buffer.asCharBuffer().get(instanceId);
        }
        catch (BufferUnderflowException e) {
            return;
        }
        connection.setJMXConnectionData(new String(url), new String(instanceId));
    }

    public synchronized void setCommittedTx(long tx) {
        int master;
        this.waitForSyncConnected();
        this.committedTx = tx;
        this.masterForCommittedTx = master = this.localDatabase.getMasterForTx(tx);
        String root = this.getRoot();
        String path = root + "/" + this.machineId + "_" + this.sequenceNr;
        byte[] data = this.dataRepresentingMe(tx, master);
        try {
            this.zooKeeper.setData(path, data, -1);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to set current tx", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted...", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFirstMasterForTx(long committedTx) {
        if (committedTx == 1L) {
            return -1;
        }
        LogExtractor extractor = null;
        try {
            extractor = LogExtractor.from((String)this.storeDir, (long)committedTx);
            long tx = extractor.extractNext(NullLogBuffer.INSTANCE);
            if (tx != committedTx) {
                this.msgLog.logMessage("Tried to extract master for tx " + committedTx + " at initialization, but got tx " + tx + " back. Will be using " + -1 + " temporarily");
                int n = -1;
                return n;
            }
            int n = extractor.getLastStartEntry().getMasterId();
            return n;
        }
        catch (IOException e) {
            this.msgLog.logMessage("Couldn't get master for " + committedTx + " using " + -1 + " temporarily", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            if (extractor != null) {
                extractor.close();
            }
        }
    }

    @Override
    public void shutdown() {
        this.msgLog.close();
        this.shutdown = true;
        super.shutdown();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public ZooKeeper getZooKeeper(boolean sync) {
        if (sync) {
            this.zooKeeper.sync(this.rootPath, null, null);
        }
        return this.zooKeeper;
    }

    @Override
    protected String getHaServer(int machineId, boolean wait) {
        return machineId == this.machineId ? this.haServer : super.getHaServer(machineId, wait);
    }

    private synchronized StoreId createCluster(StoreId storeIdSuggestion) {
        String path = "/" + this.clusterName;
        try {
            try {
                this.zooKeeper.create(path, storeIdSuggestion.serialize(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                return storeIdSuggestion;
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    try {
                        return StoreId.deserialize((byte[])this.zooKeeper.getData(path, false, null));
                    }
                    catch (KeeperException ex) {
                        throw new ZooKeeperException("Unable to read cluster store id", ex);
                    }
                }
                throw new ZooKeeperException("Unable to write cluster store id", e);
            }
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("createCluster interrupted", e);
        }
    }

    public StoreId getClusterStoreId(AbstractZooKeeperManager.WaitMode mode) {
        this.waitForSyncConnected(mode);
        this.makeSureRootPathIsFound();
        return this.storeId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[serverId:" + this.machineId + ", seq:" + this.sequenceNr + ", lastCommittedTx:" + this.committedTx + " w/ master:" + this.masterForCommittedTx + ", session:" + this.sessionId + "]";
    }

    private class WatcherImpl
    implements Watcher {
        private final Queue<WatchedEvent> unprocessedEvents = new LinkedList<WatchedEvent>();

        private WatcherImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void flushUnprocessedEvents(ZooKeeper zooKeeper) {
            Queue<WatchedEvent> queue = this.unprocessedEvents;
            synchronized (queue) {
                WatchedEvent e = null;
                while ((e = this.unprocessedEvents.poll()) != null) {
                    this.processEvent(e, zooKeeper);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            Queue<WatchedEvent> queue = this.unprocessedEvents;
            synchronized (queue) {
                if (ZooClient.this.zooKeeper == null || !this.unprocessedEvents.isEmpty()) {
                    this.unprocessedEvents.add(event);
                    return;
                }
            }
            this.processEvent(event, ZooClient.this.zooKeeper);
        }

        private void processEvent(WatchedEvent event, ZooKeeper zooKeeper) {
            try {
                String path = event.getPath();
                ZooClient.this.msgLog.logMessage(this + ", " + new Date() + " Got event: " + event + " (path=" + path + ")", true);
                if (path == null && event.getState() == Watcher.Event.KeeperState.Expired) {
                    ZooClient.this.keeperState = Watcher.Event.KeeperState.Expired;
                    ZooClient.this.clusterReceiver.reconnect(new InformativeStackTrace("Reconnect due to session expired"));
                } else if (path == null && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    boolean masterBeforeIWriteDiffers;
                    long newSessionId = zooKeeper.getSessionId();
                    Pair<Master, Machine> masterBeforeIWrite = ZooClient.this.getMasterFromZooKeeper(false, false);
                    ZooClient.this.msgLog.logMessage("Get master before write:" + masterBeforeIWrite);
                    boolean bl = masterBeforeIWriteDiffers = ((Machine)masterBeforeIWrite.other()).getMachineId() != ((Machine)ZooClient.this.getCachedMaster().other()).getMachineId();
                    if (newSessionId != ZooClient.this.sessionId || masterBeforeIWriteDiffers) {
                        if (ZooClient.this.writeLastCommittedTx) {
                            ZooClient.this.sequenceNr = ZooClient.this.setup();
                            ZooClient.this.msgLog.logMessage("Did setup, seq=" + ZooClient.this.sequenceNr + " new sessionId=" + newSessionId);
                            Pair<Master, Machine> masterAfterIWrote = ZooClient.this.getMasterFromZooKeeper(false, false);
                            ZooClient.this.msgLog.logMessage("Get master after write:" + masterAfterIWrote);
                            if (ZooClient.this.sessionId != -1L) {
                                ZooClient.this.clusterReceiver.newMaster(new InformativeStackTrace("Got SyncConnected event from ZK"));
                            }
                            ZooClient.this.sessionId = newSessionId;
                        } else {
                            ZooClient.this.msgLog.logMessage("Didn't do setup due to told not to write");
                            ZooClient.this.keeperState = Watcher.Event.KeeperState.SyncConnected;
                            ZooClient.this.subscribeToDataChangeWatcher(ZooClient.MASTER_REBOUND_CHILD);
                        }
                        ZooClient.this.keeperState = Watcher.Event.KeeperState.SyncConnected;
                    } else {
                        ZooClient.this.msgLog.logMessage("SyncConnected with same session id: " + ZooClient.this.sessionId);
                        ZooClient.this.keeperState = Watcher.Event.KeeperState.SyncConnected;
                    }
                } else if (path == null && event.getState() == Watcher.Event.KeeperState.Disconnected) {
                    ZooClient.this.keeperState = Watcher.Event.KeeperState.Disconnected;
                } else if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                    ZooClient.this.msgLog.logMessage("Got a NodeDeleted event for " + path);
                    ZooKeeperMachine currentMaster = (ZooKeeperMachine)ZooClient.this.getCachedMaster().other();
                    if (path.contains(currentMaster.getZooKeeperPath())) {
                        ZooClient.this.msgLog.logMessage("Acting on it, calling newMaster()");
                        ZooClient.this.clusterReceiver.newMaster(new InformativeStackTrace("NodeDeleted event received (a machine left the cluster)"));
                    }
                } else if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                    int newMasterMachineId = ZooClient.this.toInt(ZooClient.this.getZooKeeper(true).getData(path, true, null));
                    ZooClient.this.msgLog.logMessage("Got event data " + newMasterMachineId);
                    if (path.contains(ZooClient.MASTER_NOTIFY_CHILD)) {
                        if (newMasterMachineId == ZooClient.this.machineId) {
                            ZooClient.this.clusterReceiver.newMaster(new InformativeStackTrace("NodeDataChanged event received (someone though I should be the master)"));
                        }
                    } else if (path.contains(ZooClient.MASTER_REBOUND_CHILD)) {
                        if (newMasterMachineId != ZooClient.this.machineId) {
                            ZooClient.this.clusterReceiver.newMaster(new InformativeStackTrace("NodeDataChanged event received (new master ensures I'm slave)"));
                        }
                    } else {
                        ZooClient.this.msgLog.logMessage("Unrecognized data change " + path);
                    }
                }
            }
            catch (BrokerShutDownException e) {
            }
            catch (Exception e) {
                ZooClient.this.msgLog.logMessage("Error in ZooClient.process", (Throwable)e, true);
                throw Exceptions.launderedException((Throwable)e);
            }
            finally {
                ZooClient.this.msgLog.flush();
            }
        }
    }
}

