/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.logging.Logging;

public class AbstractHAGraphDatabase
extends AbstractGraphDatabase {
    protected Broker broker;
    private NodeProxy.NodeLookup nodeLookup;
    private RelationshipProxy.RelationshipLookups relationshipLookups;
    private HighlyAvailableGraphDatabase highlyAvailableGraphDatabase;
    private final Caches caches;

    public AbstractHAGraphDatabase(String storeDir, Map<String, String> params, StoreId storeId, HighlyAvailableGraphDatabase highlyAvailableGraphDatabase, Broker broker, Logging logging, NodeProxy.NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relationshipLookups, Iterable<IndexProvider> indexProviders, Iterable<KernelExtension> kernelExtensions, Iterable<CacheProvider> cacheProviders, Caches caches) {
        super(storeDir, params, indexProviders, kernelExtensions, cacheProviders);
        this.highlyAvailableGraphDatabase = highlyAvailableGraphDatabase;
        this.caches = caches;
        this.storeId = storeId;
        assert (broker != null && logging != null && nodeLookup != null && relationshipLookups != null);
        this.broker = broker;
        this.logging = logging;
        this.nodeLookup = nodeLookup;
        this.relationshipLookups = relationshipLookups;
    }

    protected KernelData createKernelData() {
        return new AbstractGraphDatabase.DefaultKernelData((AbstractGraphDatabase)this, this.config, (GraphDatabaseAPI)this);
    }

    protected NodeProxy.NodeLookup createNodeLookup() {
        return this.nodeLookup;
    }

    protected RelationshipProxy.RelationshipLookups createRelationshipLookups() {
        return this.relationshipLookups;
    }

    protected Logging createStringLogger() {
        return this.logging;
    }

    public HighlyAvailableGraphDatabase getHighlyAvailableGraphDatabase() {
        return this.highlyAvailableGraphDatabase;
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    protected Caches createCaches() {
        return this.caches;
    }
}

