/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.backup.TestBackupToolEmbedded;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestBackupToolHa {
    private LocalhostZooKeeperCluster zk;
    private List<GraphDatabaseService> instances;
    private DbRepresentation representation;

    @Before
    public void before() throws Exception {
        FileUtils.deleteDirectory((File)new File("target/var/db"));
        FileUtils.deleteDirectory((File)new File("target/var/backup-db"));
        this.zk = new LocalhostZooKeeperCluster(TestBackupToolHa.class, 2181, 2182, 2183);
        this.instances = new ArrayList<GraphDatabaseService>();
        for (int i = 0; i < 3; ++i) {
            String storeDir = new File("target/var/db", "" + i).getAbsolutePath();
            Map config = MapUtil.stringMap((String[])new String[]{"ha.server_id", "" + i, "ha.server", "localhost:" + (6666 + i), "ha.coordinators", this.zk.getConnectionString(), "enable_online_backup", "port=" + (4444 + i)});
            HighlyAvailableGraphDatabase instance = new HighlyAvailableGraphDatabase(storeDir, config);
            this.instances.add((GraphDatabaseService)instance);
        }
        this.representation = TestBackupToolEmbedded.createSomeData((GraphDatabaseService)this.instances.get(1));
    }

    @After
    public void after() throws Exception {
        for (GraphDatabaseService instance : this.instances) {
            instance.shutdown();
        }
        this.zk.shutdown();
    }

    @Test
    @Ignore(value="getting build back to green")
    public void makeSureBackupCanBePerformedFromCluster() throws Exception {
        Assert.assertEquals((long)0L, (long)TestBackupToolEmbedded.runBackupToolFromOtherJvmToGetExitCode((String[])new String[]{"-full", "-from", "ha://localhost:2181", "-to", "target/var/backup-db"}));
        Assert.assertEquals((Object)this.representation, (Object)DbRepresentation.of((String)"target/var/backup-db"));
        DbRepresentation newRepresentation = TestBackupToolEmbedded.createSomeData((GraphDatabaseService)this.instances.get(2));
        Assert.assertEquals((long)0L, (long)TestBackupToolEmbedded.runBackupToolFromOtherJvmToGetExitCode((String[])new String[]{"-incremental", "-from", "ha://localhost:2182", "-to", "target/var/backup-db"}));
        Assert.assertEquals((Object)newRepresentation, (Object)DbRepresentation.of((String)"target/var/backup-db"));
    }
}

