/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.kernel.ConfigurationPrefix;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractBroker
implements Broker {
    private static final StoreId storeId = new StoreId();
    private Configuration config;

    public AbstractBroker(Configuration config) {
        this.config = config;
    }

    @Override
    public void setLastCommittedTxId(long txId) {
    }

    protected Configuration getConfig() {
        return this.config;
    }

    @Override
    public int getMyMachineId() {
        return this.config.server_id();
    }

    @Override
    public void notifyMasterChange(Machine newMaster) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void restart() {
    }

    @Override
    public void start() {
    }

    @Override
    public Machine getMasterExceptMyself() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebindMaster() {
    }

    @Override
    public void setConnectionInformation(KernelData kernel) {
    }

    @Override
    public ConnectionInformation getConnectionInformation(int machineId) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support ConnectionInformation");
    }

    @Override
    public ConnectionInformation[] getConnectionInformation() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support ConnectionInformation");
    }

    @Override
    public StoreId getClusterStoreId() {
        return storeId;
    }

    @Override
    public void logStatus(StringLogger msgLog) {
    }

    @ConfigurationPrefix(value="ha.")
    public static interface Configuration {
        public int server_id();
    }
}

