/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.backup.TestBackupToolEmbedded;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestBackupToolHa {
    private LocalhostZooKeeperCluster zk;
    private List<GraphDatabaseService> instances;
    private DbRepresentation representation;

    public void startCluster(String clusterName) throws Exception {
        FileUtils.deleteDirectory((File)new File("target/var/db"));
        FileUtils.deleteDirectory((File)new File("target/var/backup-db"));
        this.zk = LocalhostZooKeeperCluster.standardZoo(this.getClass());
        this.instances = new ArrayList<GraphDatabaseService>();
        for (int i = 0; i < 3; ++i) {
            String storeDir = new File("target/var/db", "" + i).getAbsolutePath();
            Map config = MapUtil.stringMap((String[])new String[]{"ha.server_id", "" + i, "ha.server", "localhost:" + (6666 + i), "ha.coordinators", this.zk.getConnectionString(), "enable_online_backup", "port=" + (4444 + i)});
            if (clusterName != null) {
                config.put("ha.cluster_name", clusterName);
            }
            HighlyAvailableGraphDatabase instance = new HighlyAvailableGraphDatabase(storeDir, config);
            this.instances.add((GraphDatabaseService)instance);
        }
        this.representation = TestBackupToolEmbedded.createSomeData((GraphDatabaseService)this.instances.get(1));
    }

    @After
    public void after() throws Exception {
        for (GraphDatabaseService instance : this.instances) {
            instance.shutdown();
        }
        this.zk.shutdown();
    }

    @Test
    public void makeSureBackupCanBePerformedFromClusterWithDefaultName() throws Exception {
        this.testBackupFromCluster(null, null);
    }

    @Test
    public void makeSureBackupCanBePerformedFromClusterWithCustomName() throws Exception {
        String clusterName = "local.jvm.cluster";
        this.testBackupFromCluster(clusterName, clusterName);
    }

    @Test
    public void makeSureBackupCanBePerformedFromNonExistentCluster() throws Exception {
        String clusterName = "local.jvm.cluster";
        this.startCluster(clusterName);
        Assert.assertEquals((long)1L, (long)TestBackupToolEmbedded.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments(true, "ha://localhost:2181", "target/var/backup-db", null)));
    }

    private void testBackupFromCluster(String clusterName, String askForCluster) throws Exception {
        this.startCluster(clusterName);
        Assert.assertEquals((long)0L, (long)TestBackupToolEmbedded.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments(true, "ha://localhost:2181", "target/var/backup-db", clusterName)));
        Assert.assertEquals((Object)this.representation, (Object)DbRepresentation.of((String)"target/var/backup-db"));
        DbRepresentation newRepresentation = TestBackupToolEmbedded.createSomeData((GraphDatabaseService)this.instances.get(2));
        Assert.assertEquals((long)0L, (long)TestBackupToolEmbedded.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments(false, "ha://localhost:2182", "target/var/backup-db", clusterName)));
        Assert.assertEquals((Object)newRepresentation, (Object)DbRepresentation.of((String)"target/var/backup-db"));
    }

    private String[] backupArguments(boolean trueForFull, String from, String to, String clusterName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(trueForFull ? "-full" : "-incremental");
        args.add("-from");
        args.add(from);
        args.add("-to");
        args.add(to);
        if (clusterName != null) {
            args.add("-cluster");
            args.add(clusterName);
        }
        return args.toArray(new String[args.size()]);
    }
}

