/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.kernel.DefaultLastCommittedTxIdSetter;
import org.neo4j.kernel.ha.AsyncZooKeeperLastCommittedTxIdSetter;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.ZooKeeperLastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;

public enum SlaveUpdateMode {
    sync(true){

        @Override
        public LastCommittedTxIdSetter createUpdater(Broker broker) {
            return new ZooKeeperLastCommittedTxIdSetter(broker);
        }
    }
    ,
    async(true){

        @Override
        public LastCommittedTxIdSetter createUpdater(Broker broker) {
            return new AsyncZooKeeperLastCommittedTxIdSetter(broker);
        }
    }
    ,
    none(false){

        @Override
        public LastCommittedTxIdSetter createUpdater(Broker broker) {
            return new DefaultLastCommittedTxIdSetter();
        }
    };

    public final boolean syncWithZooKeeper;

    private SlaveUpdateMode(boolean syncWithZooKeeper) {
        this.syncWithZooKeeper = syncWithZooKeeper;
    }

    public abstract LastCommittedTxIdSetter createUpdater(Broker var1);
}

