/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.ConfigurationMigrator;
import org.neo4j.kernel.impl.util.StringLogger;

public class EnterpriseConfigurationMigrator
extends ConfigurationMigrator {
    public EnterpriseConfigurationMigrator(StringLogger messageLog) {
        super(messageLog);
    }

    public Map<String, String> migrateConfiguration(Map<String, String> inputParams) {
        HashMap<String, String> migratedConfiguration = new HashMap<String, String>();
        for (Map.Entry configEntry : super.migrateConfiguration(inputParams).entrySet()) {
            String key = (String)configEntry.getKey();
            String value = (String)configEntry.getValue();
            if (key.equals("ha.machine_id")) {
                migratedConfiguration.put("ha.server_id", value);
                this.deprecationMessage("ha.machine_id has been replaced with ha.server_id");
                continue;
            }
            if (key.equals("ha.zoo_keeper_servers")) {
                migratedConfiguration.put("ha.coordinators", value);
                this.deprecationMessage("ha.zoo_keeper_servers has been replaced with ha.coordinators");
                continue;
            }
            migratedConfiguration.put(key, value);
        }
        return migratedConfiguration;
    }
}

