/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.ha.AbstractHAGraphDatabase;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.MasterIdGeneratorFactory;
import org.neo4j.kernel.ha.MasterTxHook;
import org.neo4j.kernel.ha.MasterTxIdGenerator;
import org.neo4j.kernel.ha.ZooKeeperLastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.util.StringLogger;

public class MasterGraphDatabase
extends AbstractHAGraphDatabase {
    private StoreId storeId;

    public MasterGraphDatabase(String storeDir, Map<String, String> params, StoreId storeId, HighlyAvailableGraphDatabase highlyAvailableGraphDatabase, Broker broker, StringLogger logger, NodeProxy.NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relationshipLookups) {
        super(storeDir, params, highlyAvailableGraphDatabase, broker, logger, nodeLookup, relationshipLookups);
        this.storeId = storeId;
        this.run();
    }

    protected StoreFactory createStoreFactory() {
        return new StoreFactory(this.params, this.idGeneratorFactory, this.fileSystem, this.lastCommittedTxIdSetter, this.msgLog, this.txHook){

            public NeoStore createNeoStore(String fileName) {
                return super.createNeoStore(fileName, MasterGraphDatabase.this.storeId);
            }
        };
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        return new MasterIdGeneratorFactory();
    }

    protected TxIdGenerator createTxIdGenerator() {
        return new MasterTxIdGenerator(this.broker);
    }

    protected TxHook createTxHook() {
        return new MasterTxHook(super.createTxHook());
    }

    protected LastCommittedTxIdSetter createLastCommittedTxIdSetter() {
        return new ZooKeeperLastCommittedTxIdSetter(this.broker);
    }
}

