/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.kernel.GraphDatabaseSPI;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.ha.AbstractHAGraphDatabase;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.SlaveIdGenerator;
import org.neo4j.kernel.ha.SlaveLockManager;
import org.neo4j.kernel.ha.SlaveTxHook;
import org.neo4j.kernel.ha.SlaveTxIdGenerator;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.util.StringLogger;

public class SlaveGraphDatabase
extends AbstractHAGraphDatabase {
    private ResponseReceiver responseReceiver;
    private LastCommittedTxIdSetter lastCommittedTxIdSetter;
    private SlaveIdGenerator.SlaveIdGeneratorFactory slaveIdGeneratorFactory;

    public SlaveGraphDatabase(String storeDir, Map<String, String> params, HighlyAvailableGraphDatabase highlyAvailableGraphDatabase, Broker broker, StringLogger logger, ResponseReceiver responseReceiver, LastCommittedTxIdSetter lastCommittedTxIdSetter, NodeProxy.NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relationshipLookups) {
        super(storeDir, params, highlyAvailableGraphDatabase, broker, logger, nodeLookup, relationshipLookups);
        assert (broker != null && logger != null && responseReceiver != null && lastCommittedTxIdSetter != null && nodeLookup != null && relationshipLookups != null);
        this.responseReceiver = responseReceiver;
        this.lastCommittedTxIdSetter = lastCommittedTxIdSetter;
        this.run();
    }

    protected TxHook createTxHook() {
        return new SlaveTxHook(this.broker, this.responseReceiver, (GraphDatabaseSPI)this);
    }

    protected LastCommittedTxIdSetter createLastCommittedTxIdSetter() {
        return this.lastCommittedTxIdSetter;
    }

    protected TxIdGenerator createTxIdGenerator() {
        assert (this.txManager != null);
        return new SlaveTxIdGenerator(this.broker, this.responseReceiver, (TransactionManager)this.txManager);
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        this.slaveIdGeneratorFactory = new SlaveIdGenerator.SlaveIdGeneratorFactory(this.broker, this.responseReceiver);
        return this.slaveIdGeneratorFactory;
    }

    protected LockManager createLockManager() {
        assert (this.txManager != null && this.txHook != null);
        return new SlaveLockManager(this.ragManager, (TxManager)this.txManager, this.txHook, this.broker, this.responseReceiver);
    }

    public void forgetIdAllocationsFromMaster() {
        this.slaveIdGeneratorFactory.forgetIdAllocationsFromMaster();
    }
}

