/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import javax.transaction.Transaction;
import org.neo4j.com.ComException;
import org.neo4j.kernel.GraphDatabaseSPI;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.transaction.TxHook;

public class SlaveTxHook
implements TxHook {
    private final Broker broker;
    private final ResponseReceiver receiver;
    private GraphDatabaseSPI spi;

    public SlaveTxHook(Broker broker, ResponseReceiver receiver, GraphDatabaseSPI spi) {
        this.broker = broker;
        this.receiver = receiver;
        this.spi = spi;
    }

    public void initializeTransaction(int eventIdentifier) {
        try {
            this.receiver.receive(((Master)this.broker.getMaster().first()).initializeTx(this.receiver.getSlaveContext(eventIdentifier)));
        }
        catch (ZooKeeperException e) {
            this.receiver.newMaster(e);
            throw e;
        }
        catch (ComException e) {
            this.receiver.newMaster((Exception)((Object)e));
            throw e;
        }
    }

    public boolean hasAnyLocks(Transaction tx) {
        return this.spi.getLockReleaser().hasLocks(tx);
    }

    public void finishTransaction(int eventIdentifier, boolean success) {
        try {
            this.receiver.receive(((Master)this.broker.getMaster().first()).finishTransaction(this.receiver.getSlaveContext(eventIdentifier), success));
        }
        catch (ZooKeeperException e) {
            this.receiver.newMaster(e);
            throw e;
        }
        catch (ComException e) {
            this.receiver.newMaster((Exception)((Object)e));
            throw e;
        }
    }

    public boolean freeIdsDuringRollback() {
        return false;
    }
}

