/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.EnterpriseGraphDatabaseFactory;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.SubProcessTestRunner;

@ForeignBreakpoints(value={@ForeignBreakpoints.BreakpointDef(type="org.neo4j.com.Client", method="makeSureNextTransactionIsFullyFetched", on=BreakPoint.Event.ENTRY), @ForeignBreakpoints.BreakpointDef(type="org.neo4j.com.DechunkingChannelBuffer", method="readNextChunk", on=BreakPoint.Event.EXIT)})
@RunWith(value=SubProcessTestRunner.class)
@Ignore(value="This test depends on chuncked requests, otherwise it will hang. So either reduce the Protocol.DEFAULT_FRAME_LENGTH to 1024or create a huge difference in the stores between master and slave which will lead to a multichunk response.")
public class TestClientThreadIsolation {
    private static LocalhostZooKeeperCluster zoo;
    private static DebuggedThread txCopyingThread;
    private static DebuggedThread interferingThread;
    private static CountDownLatch latch;

    @BeforeClass
    public static void startZoo() {
        zoo = new LocalhostZooKeeperCluster(TestClientThreadIsolation.class, 3181, 3182, 3183);
    }

    @AfterClass
    public static void stopZoo() {
        zoo.shutdown();
    }

    @Test
    @EnabledBreakpoints(value={"makeSureNextTransactionIsFullyFetched", "readNextChunk", "waitTxCopyToStart", "finish"})
    public void testTransactionsPulled() throws Exception {
        HighlyAvailableGraphDatabase master = (HighlyAvailableGraphDatabase)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(TargetDirectory.forTest(TestClientThreadIsolation.class).directory("master", true).getAbsolutePath()).setConfig((GraphDatabaseSetting)HaSettings.coordinators, zoo.getConnectionString()).setConfig((GraphDatabaseSetting)HaSettings.server_id, "1").newGraphDatabase();
        HighlyAvailableGraphDatabase slave1 = (HighlyAvailableGraphDatabase)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(TargetDirectory.forTest(TestClientThreadIsolation.class).directory("slave1", true).getAbsolutePath()).setConfig((GraphDatabaseSetting)HaSettings.coordinators, zoo.getConnectionString()).setConfig((GraphDatabaseSetting)HaSettings.server_id, "2").setConfig((GraphDatabaseSetting)HaSettings.max_concurrent_channels_per_slave, "2").newGraphDatabase();
        Transaction masterTx = master.beginTx();
        master.createNode().createRelationshipTo(master.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"master")).setProperty("largeArray", (Object)new int[20000]);
        masterTx.success();
        masterTx.finish();
        Assert.assertEquals((long)1L, (long)((Machine)master.getBroker().getMaster().other()).getMachineId());
        Assert.assertEquals((long)1L, (long)((Machine)slave1.getBroker().getMaster().other()).getMachineId());
        Thread thread1 = new Thread(new Runnable(){

            @Override
            public void run() {
            }
        }, "thread 1");
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
            }
        }, "thread 2");
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        Assert.assertTrue((boolean)master.getReferenceNode().getRelationships(new RelationshipType[]{DynamicRelationshipType.withName((String)"test")}).iterator().hasNext());
    }

    @BreakpointTrigger(value="waitTxCopyToStart")
    private void waitTxCopyToStart() {
    }

    @BreakpointTrigger(value="finish")
    private void finish() {
    }

    @BreakpointHandler(value={"waitTxCopyToStart"})
    public static void onWaitTxCopyToStart(BreakPoint self, DebugInterface di) {
        interferingThread = di.thread().suspend(null);
        latch.countDown();
    }

    @BreakpointHandler(value={"finish"})
    public static void onFinish(BreakPoint self, DebugInterface di) {
        txCopyingThread.resume();
    }

    @BreakpointHandler(value={"makeSureNextTransactionIsFullyFetched"})
    public static void onStartingStoreCopy(BreakPoint self, DebugInterface di, @BreakpointHandler(value={"readNextChunk"}) BreakPoint onReadNextChunk) throws Exception {
        latch.await();
        txCopyingThread = di.thread();
        self.disable();
    }

    @BreakpointHandler(value={"readNextChunk"})
    public static void onReadNextChunk(BreakPoint self, DebugInterface di) throws Exception {
        if (txCopyingThread != null && di.thread().name().equals(txCopyingThread.name())) {
            txCopyingThread.suspend(null);
            interferingThread.resume();
            self.disable();
        }
    }

    static {
        latch = new CountDownLatch(1);
    }
}

