/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedList;
import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.AbstractHAGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.management.BranchedStore;
import org.neo4j.management.BranchedStoreInfo;

public final class BranchedStoreBean
extends ManagementBeanProvider {
    public BranchedStoreBean() {
        super(BranchedStore.class);
    }

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        if (!BranchedStoreBean.isHA(management)) {
            return null;
        }
        return new BranchedStoreImpl(management, true);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        if (!BranchedStoreBean.isHA(management)) {
            return null;
        }
        return new BranchedStoreImpl(management);
    }

    private static boolean isHA(ManagementData management) {
        return management.getKernelData().graphDatabase() instanceof AbstractHAGraphDatabase;
    }

    private static class BranchedStoreImpl
    extends Neo4jMBean
    implements BranchedStore {
        private final File storePath;
        private static final FilenameFilter branchedDataDirectoryFilenameFilter = new BranchedDataDirectoryFilenameFilter();

        protected BranchedStoreImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.storePath = this.extractStorePath(management);
        }

        protected BranchedStoreImpl(ManagementData management, boolean isMXBean) {
            super(management, isMXBean, new String[0]);
            this.storePath = this.extractStorePath(management);
        }

        private File extractStorePath(ManagementData management) {
            File path;
            NeoStoreXaDataSource nioneodb = management.getKernelData().graphDatabase().getXaDataSourceManager().getNeoStoreDataSource();
            try {
                path = new File(nioneodb.getStoreDir()).getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                path = new File(nioneodb.getStoreDir()).getAbsoluteFile();
            }
            return path;
        }

        public BranchedStoreInfo[] getBranchedStores() {
            LinkedList<BranchedStoreInfo> toReturn = new LinkedList<BranchedStoreInfo>();
            for (String filename : this.storePath.list(branchedDataDirectoryFilenameFilter)) {
                toReturn.add(this.parseBranchedStore(filename));
            }
            return toReturn.toArray(new BranchedStoreInfo[0]);
        }

        private BranchedStoreInfo parseBranchedStore(String branchedStoreDirName) {
            File theDir = new File(this.storePath, branchedStoreDirName);
            File theNeostoreFile = new File(theDir, "neostore");
            String timestampFromFilename = branchedStoreDirName.substring(HighlyAvailableGraphDatabase.BranchedDataPolicy.BRANCH_PREFIX.length());
            long timestamp = Long.parseLong(timestampFromFilename);
            long txId = NeoStore.getTxId((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (String)theNeostoreFile.getAbsolutePath());
            return new BranchedStoreInfo(branchedStoreDirName, txId, timestamp);
        }

        private static final class BranchedDataDirectoryFilenameFilter
        implements FilenameFilter {
            private BranchedDataDirectoryFilenameFilter() {
            }

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory() && name.startsWith(HighlyAvailableGraphDatabase.BranchedDataPolicy.BRANCH_PREFIX);
            }
        }
    }
}

