/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.com.MasterUtil;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.TxExtractor;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.LockStatus;
import org.neo4j.kernel.ha.LockableNode;
import org.neo4j.kernel.ha.LockableRelationship;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.UnableToResumeTransactionException;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;

public class MasterImpl
implements Master {
    private static final int ID_GRAB_SIZE = 1000;
    public static final int UNFINISHED_TRANSACTION_CLEANUP_DELAY = 5;
    private final GraphDatabaseAPI graphDb;
    private final StringLogger msgLog;
    private final Map<SlaveContext, MasterTransaction> transactions = Collections.synchronizedMap(new HashMap());
    private final ScheduledExecutorService unfinishedTransactionsExecutor;
    private int unfinishedTransactionThreshold;
    private static LockGrabber READ_LOCK_GRABBER = new LockGrabber(){

        @Override
        public void grab(LockManager lockManager, LockReleaser lockReleaser, Object entity) {
            lockManager.getReadLock(entity);
            lockReleaser.addLockToTransaction(entity, LockType.READ);
        }
    };
    private static LockGrabber WRITE_LOCK_GRABBER = new LockGrabber(){

        @Override
        public void grab(LockManager lockManager, LockReleaser lockReleaser, Object entity) {
            lockManager.getWriteLock(entity);
            lockReleaser.addLockToTransaction(entity, LockType.WRITE);
        }
    };

    public MasterImpl(GraphDatabaseAPI db, int timeOut) {
        this.graphDb = db;
        this.msgLog = this.graphDb.getMessageLog();
        this.unfinishedTransactionThreshold = timeOut;
        this.unfinishedTransactionsExecutor = Executors.newSingleThreadScheduledExecutor();
        this.unfinishedTransactionsExecutor.scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HashMap safeTransactions = null;
                    Map map = MasterImpl.this.transactions;
                    synchronized (map) {
                        safeTransactions = new HashMap(MasterImpl.this.transactions);
                    }
                    for (Map.Entry entry : safeTransactions.entrySet()) {
                        long time = ((MasterTransaction)entry.getValue()).timeLastSuspended.get();
                        if (time == 0L || System.currentTimeMillis() - time < (long)(MasterImpl.this.unfinishedTransactionThreshold * 1000)) continue;
                        long displayableTime = time == 0L ? 0L : System.currentTimeMillis() - time;
                        MasterImpl.this.msgLog.logMessage("Found old tx " + entry.getKey() + ", " + ((MasterTransaction)entry.getValue()).transaction + ", " + displayableTime);
                        try {
                            Transaction otherTx = MasterImpl.this.suspendOtherAndResumeThis((SlaveContext)entry.getKey(), false);
                            MasterImpl.this.finishThisAndResumeOther(otherTx, (SlaveContext)entry.getKey(), false);
                            MasterImpl.this.msgLog.logMessage("Rolled back old tx " + entry.getKey() + ", " + ((MasterTransaction)entry.getValue()).transaction + ", " + displayableTime);
                        }
                        catch (IllegalStateException e) {
                        }
                        catch (Throwable t) {
                            MasterImpl.this.msgLog.logMessage("Unable to roll back old tx " + entry.getKey() + ", " + ((MasterTransaction)entry.getValue()).transaction + ", " + displayableTime);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public GraphDatabaseAPI getGraphDb() {
        return this.graphDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Void> initializeTx(SlaveContext context) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context, true);
        try {
            Response<Object> response = this.packResponse(context, null);
            return response;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response<LockResult> acquireLock(SlaveContext context, LockGrabber lockGrabber, Object ... entities) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context, false);
        try {
            LockManager lockManager = this.graphDb.getLockManager();
            LockReleaser lockReleaser = this.graphDb.getLockReleaser();
            for (Object entity : entities) {
                lockGrabber.grab(lockManager, lockReleaser, entity);
            }
            Response<LockResult> response = this.packResponse(context, new LockResult(LockStatus.OK_LOCKED));
            return response;
        }
        catch (DeadlockDetectedException e) {
            Response<LockResult> response = this.packResponse(context, new LockResult(e.getMessage()));
            return response;
        }
        catch (IllegalResourceException e) {
            Response<LockResult> response = this.packResponse(context, new LockResult(LockStatus.NOT_LOCKED));
            return response;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx, context);
        }
    }

    private <T> Response<T> packResponse(SlaveContext context, T response) {
        return this.packResponse(context, response, (Predicate<Long>)MasterUtil.ALL);
    }

    private <T> Response<T> packResponse(SlaveContext context, T response, Predicate<Long> filter) {
        return MasterUtil.packResponse((GraphDatabaseAPI)this.graphDb, (SlaveContext)context, response, filter);
    }

    private Transaction getTx(SlaveContext txId) {
        MasterTransaction result = this.transactions.get(txId);
        if (result != null) {
            result.resetTime();
            return result.transaction;
        }
        return null;
    }

    private Transaction beginTx(SlaveContext txId) {
        try {
            TransactionManager txManager = this.graphDb.getTxManager();
            txManager.begin();
            Transaction tx = txManager.getTransaction();
            this.transactions.put(txId, new MasterTransaction(tx));
            return tx;
        }
        catch (NotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Transaction suspendOtherAndResumeThis(SlaveContext txId, boolean allowBegin) {
        try {
            TransactionManager txManager = this.graphDb.getTxManager();
            Transaction otherTx = txManager.getTransaction();
            Transaction transaction = this.getTx(txId);
            if (otherTx != null && otherTx == transaction) {
                return null;
            }
            if (otherTx != null) {
                txManager.suspend();
            }
            if (transaction == null) {
                if (!allowBegin) throw new IllegalStateException("Transaction " + txId + " has either timed out on the" + " master or was not started on this master. There may have been a master switch" + " between the time this transaction started and up to now. This transaction" + " cannot continue since the state from the previous master isn't transferred.");
                this.beginTx(txId);
                return otherTx;
            }
            try {
                txManager.resume(transaction);
                return otherTx;
            }
            catch (IllegalStateException e) {
                throw new UnableToResumeTransactionException(e);
            }
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    void suspendThisAndResumeOther(Transaction otherTx, SlaveContext txId) {
        try {
            MasterTransaction tx = this.transactions.get(txId);
            if (tx.finishAsap()) {
                this.finishThisAndResumeOther(otherTx, txId, false);
                return;
            }
            TransactionManager txManager = this.graphDb.getTxManager();
            tx.updateTime();
            txManager.suspend();
            if (otherTx != null) {
                txManager.resume(otherTx);
            }
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    void finishThisAndResumeOther(Transaction otherTx, SlaveContext txId, boolean success) {
        try {
            TransactionManager txManager = this.graphDb.getTxManager();
            if (success) {
                txManager.commit();
            } else {
                txManager.rollback();
            }
            this.transactions.remove(txId);
            if (otherTx != null) {
                txManager.resume(otherTx);
            }
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    @Override
    public Response<LockResult> acquireNodeReadLock(SlaveContext context, long ... nodes) {
        return this.acquireLock(context, READ_LOCK_GRABBER, this.nodesById(nodes));
    }

    @Override
    public Response<LockResult> acquireNodeWriteLock(SlaveContext context, long ... nodes) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, this.nodesById(nodes));
    }

    @Override
    public Response<LockResult> acquireRelationshipReadLock(SlaveContext context, long ... relationships) {
        return this.acquireLock(context, READ_LOCK_GRABBER, this.relationshipsById(relationships));
    }

    @Override
    public Response<LockResult> acquireRelationshipWriteLock(SlaveContext context, long ... relationships) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, this.relationshipsById(relationships));
    }

    @Override
    public Response<LockResult> acquireGraphReadLock(SlaveContext context) {
        return this.acquireLock(context, READ_LOCK_GRABBER, this.graphProperties());
    }

    @Override
    public Response<LockResult> acquireGraphWriteLock(SlaveContext context) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, this.graphProperties());
    }

    private PropertyContainer graphProperties() {
        return this.graphDb.getNodeManager().getGraphProperties();
    }

    private Node[] nodesById(long[] ids) {
        Node[] result = new Node[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = new LockableNode(ids[i]);
        }
        return result;
    }

    private Relationship[] relationshipsById(long[] ids) {
        Relationship[] result = new Relationship[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = new LockableRelationship(ids[i]);
        }
        return result;
    }

    @Override
    public Response<IdAllocation> allocateIds(IdType idType) {
        IdGenerator generator = this.graphDb.getIdGeneratorFactory().get(idType);
        IdAllocation result = new IdAllocation(generator.nextIdBatch(1000), generator.getHighId(), generator.getDefragCount());
        return MasterUtil.packResponseWithoutTransactionStream((GraphDatabaseAPI)this.graphDb, (SlaveContext)SlaveContext.EMPTY, (Object)result);
    }

    @Override
    public Response<Long> commitSingleResourceTransaction(SlaveContext context, String resource, TxExtractor txGetter) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context, false);
        try {
            XaDataSource dataSource = this.graphDb.getXaDataSourceManager().getXaDataSource(resource);
            final long txId = dataSource.applyPreparedTransaction(txGetter.extract());
            Predicate<Long> upUntilThisTx = new Predicate<Long>(){

                public boolean accept(Long item) {
                    return item < txId;
                }
            };
            Response<Long> response = this.packResponse(context, txId, upUntilThisTx);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.suspendThisAndResumeOther(otherTx, context);
        }
    }

    @Override
    public Response<Void> finishTransaction(SlaveContext context, boolean success) {
        Transaction otherTx;
        try {
            otherTx = this.suspendOtherAndResumeThis(context, false);
        }
        catch (UnableToResumeTransactionException e) {
            this.transactions.get(context).markAsFinishAsap();
            throw e;
        }
        this.finishThisAndResumeOther(otherTx, context, success);
        return this.packResponse(context, null);
    }

    @Override
    public Response<Integer> createRelationshipType(SlaveContext context, String name) {
        this.graphDb.getRelationshipTypeHolder().addValidRelationshipType(name, true);
        return this.packResponse(context, this.graphDb.getRelationshipTypeHolder().getIdFor(name));
    }

    @Override
    public Response<Void> pullUpdates(SlaveContext context) {
        return this.packResponse(context, null);
    }

    @Override
    public Response<Pair<Integer, Long>> getMasterIdForCommittedTx(long txId, StoreId storeId) {
        NeoStoreXaDataSource nioneoDataSource = this.graphDb.getXaDataSourceManager().getNeoStoreDataSource();
        try {
            Pair masterId = nioneoDataSource.getMasterForCommittedTx(txId);
            return MasterUtil.packResponseWithoutTransactionStream((GraphDatabaseAPI)this.graphDb, (SlaveContext)SlaveContext.EMPTY, (Object)masterId);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't get master ID for " + txId, e);
        }
    }

    @Override
    public Response<Void> copyStore(SlaveContext context, StoreWriter writer) {
        context = MasterUtil.rotateLogsAndStreamStoreFiles((GraphDatabaseAPI)this.graphDb, (boolean)true, (StoreWriter)writer);
        writer.done();
        return this.packResponse(context, null);
    }

    @Override
    public Response<Void> copyTransactions(SlaveContext context, String dsName, long startTxId, long endTxId) {
        return MasterUtil.getTransactions((GraphDatabaseAPI)this.graphDb, (String)dsName, (long)startTxId, (long)endTxId);
    }

    @Override
    public void shutdown() {
        this.unfinishedTransactionsExecutor.shutdown();
    }

    @Override
    public Response<LockResult> acquireIndexReadLock(SlaveContext context, String index, String key) {
        return this.acquireLock(context, READ_LOCK_GRABBER, new NodeManager.IndexLock(index, key));
    }

    @Override
    public Response<LockResult> acquireIndexWriteLock(SlaveContext context, String index, String key) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, new NodeManager.IndexLock(index, key));
    }

    public Map<Integer, Collection<SlaveContext>> getOngoingTransactions() {
        HashMap<Integer, Collection<SlaveContext>> result = new HashMap<Integer, Collection<SlaveContext>>();
        for (SlaveContext context : this.transactions.keySet()) {
            ArrayList<SlaveContext> txs = (ArrayList<SlaveContext>)result.get(context.machineId());
            if (txs == null) {
                txs = new ArrayList<SlaveContext>();
                result.put(context.machineId(), txs);
            }
            txs.add(context);
        }
        return result;
    }

    static class MasterTransaction {
        private final Transaction transaction;
        private final AtomicLong timeLastSuspended = new AtomicLong();
        private volatile boolean finishAsap;

        MasterTransaction(Transaction transaction) {
            this.transaction = transaction;
        }

        void updateTime() {
            this.timeLastSuspended.set(System.currentTimeMillis());
        }

        void resetTime() {
            this.timeLastSuspended.set(0L);
        }

        void markAsFinishAsap() {
            this.finishAsap = true;
        }

        boolean finishAsap() {
            return this.finishAsap;
        }
    }

    private static interface LockGrabber {
        public void grab(LockManager var1, LockReleaser var2, Object var3);
    }
}

