/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.com.ComException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.EnterpriseGraphDatabaseFactory;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestPullUpdates {
    private LocalhostZooKeeperCluster zoo;
    private final HighlyAvailableGraphDatabase[] dbs = new HighlyAvailableGraphDatabase[3];
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());
    private static final int PULL_INTERVAL = 100;

    @Before
    public void doBefore() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.standardZoo(this.getClass());
        for (int i = 0; i < this.dbs.length; ++i) {
            this.dbs[i] = this.newDb(i);
        }
    }

    private HighlyAvailableGraphDatabase newDb(int i) {
        return (HighlyAvailableGraphDatabase)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("" + i, true).getAbsolutePath()).setConfig((GraphDatabaseSetting)HaSettings.server_id, "" + i).setConfig((GraphDatabaseSetting)HaSettings.server, "localhost:" + (6666 + i)).setConfig((GraphDatabaseSetting)HaSettings.coordinators, this.zoo.getConnectionString()).setConfig((GraphDatabaseSetting)HaSettings.pull_interval, "100ms").newGraphDatabase();
    }

    @After
    public void doAfter() throws Exception {
        for (HighlyAvailableGraphDatabase db : this.dbs) {
            if (db == null) continue;
            db.shutdown();
        }
        this.zoo.shutdown();
    }

    @Test
    public void makeSureUpdatePullerGetsGoingAfterMasterSwitch() throws Exception {
        int master = this.getCurrentMaster();
        this.setProperty(master, 1);
        this.awaitPropagation(1);
        this.kill(master);
        this.setProperty(this.awaitNewMaster(master), 2);
        this.start(master);
        this.awaitPropagation(2);
    }

    private int awaitNewMaster(int master) throws Exception {
        int newMaster = this.getCurrentMaster();
        while ((newMaster = this.getCurrentMaster()) == master) {
            this.powerNap();
        }
        return newMaster;
    }

    private void powerNap() throws InterruptedException {
        Thread.sleep(50L);
    }

    private void start(int master) {
        this.dbs[master] = this.newDb(master);
    }

    private void kill(int master) {
        this.dbs[master].shutdown();
        this.dbs[master] = null;
    }

    private void awaitPropagation(int i) throws Exception {
        long endTime = System.currentTimeMillis() + 10000L;
        boolean ok = false;
        while (!ok && System.currentTimeMillis() < endTime) {
            ok = true;
            for (HighlyAvailableGraphDatabase db : this.dbs) {
                Object value = db.getReferenceNode().getProperty("i", null);
                if (value != null && (Integer)value == i) continue;
                ok = false;
            }
            if (ok) continue;
            this.powerNap();
        }
        Assert.assertTrue((String)"Change wasn't propagated by pulling updates", (boolean)ok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperty(int dbId, int i) throws Exception {
        this.awaitHasMaster(dbId);
        HighlyAvailableGraphDatabase db = this.dbs[dbId];
        Transaction tx = db.beginTx();
        try {
            db.getReferenceNode().setProperty("i", (Object)i);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private void awaitHasMaster(int dbId) throws Exception {
        HighlyAvailableGraphDatabase db = this.dbs[dbId];
        long endTime = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < endTime) {
            try {
                db.pullUpdates();
                return;
            }
            catch (ComException e) {
                this.powerNap();
            }
        }
        Assert.fail((String)"Master didn't come up");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentMaster() throws Exception {
        ZooKeeperClusterClient client = new ZooKeeperClusterClient(this.zoo.getConnectionString());
        try {
            int dbId = client.getMaster().getMachineId();
            this.awaitBecomeMaster(dbId);
            int n = dbId;
            return n;
        }
        finally {
            client.shutdown();
        }
    }

    private void awaitBecomeMaster(int dbId) throws Exception {
        HighlyAvailableGraphDatabase db = this.dbs[dbId];
        long endTime = System.currentTimeMillis() + 10000L;
        while (!db.isMaster() && System.currentTimeMillis() < endTime) {
            this.powerNap();
        }
        Assert.assertTrue((boolean)db.isMaster());
    }
}

