/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.netty.channel.Channel;
import org.neo4j.com.RequestType;
import org.neo4j.com.Server;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.UnableToResumeTransactionException;
import org.neo4j.kernel.impl.util.StringLogger;

public class MasterServer
extends Server<Master, Void> {
    static final byte PROTOCOL_VERSION = 3;
    static final int FRAME_LENGTH = 0x1000000;

    public MasterServer(Master realMaster, int port, StringLogger logger, int maxConcurrentTransactions, int oldChannelThreshold, TxChecksumVerifier txVerifier) {
        super((Object)realMaster, port, logger, 0x1000000, (byte)3, maxConcurrentTransactions, oldChannelThreshold, txVerifier);
    }

    protected RequestType<Master> getRequestContext(byte id) {
        return MasterClient.HaRequestType.values()[id];
    }

    protected void finishOffChannel(Channel channel, SlaveContext context) {
        ((Master)this.getMaster()).finishTransaction(context, false);
    }

    public void shutdown() {
        super.shutdown();
        ((Master)this.getMaster()).shutdown();
    }

    protected boolean shouldLogFailureToFinishOffChannel(Throwable failure) {
        return !(failure instanceof UnableToResumeTransactionException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Collection<SlaveContext>> getSlaveInformation() {
        Map channels;
        HashSet<Integer> machineIds = new HashSet<Integer>();
        Map map = channels = this.getConnectedSlaveChannels();
        synchronized (map) {
            for (SlaveContext context : channels.values()) {
                machineIds.add(context.machineId());
            }
        }
        Map<Integer, Collection<SlaveContext>> ongoingTransactions = ((MasterImpl)this.getMaster()).getOngoingTransactions();
        for (Integer machineId : machineIds) {
            if (ongoingTransactions.containsKey(machineId)) continue;
            ongoingTransactions.put(machineId, Collections.emptyList());
        }
        return new TreeMap<Integer, Collection<SlaveContext>>(ongoingTransactions);
    }
}

