/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.MasterClient153;
import org.neo4j.kernel.ha.MasterClient17;
import org.neo4j.kernel.ha.MasterClient18;
import org.neo4j.kernel.ha.MasterClientResolver;
import org.neo4j.kernel.impl.util.StringLogger;

public class MasterClientResolverTest {
    private MasterClientResolver resolver;

    @Before
    public void before() throws Exception {
        this.resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0, 1000);
    }

    @Test
    public void testDefault() {
        Assert.assertEquals((String)"default was not the latest one", MasterClientResolver.F18.class, this.resolver.getDefault().getClass());
    }

    @Test
    public void testAskedVersionWorks() {
        Assert.assertEquals((String)"wrong version returned for version 2", MasterClientResolver.F153.class, this.resolver.getFor(2, 2).getClass());
        Assert.assertEquals((String)"wrong version returned for version 3", MasterClientResolver.F17.class, this.resolver.getFor(3, 2).getClass());
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClientResolver.F18.class, this.resolver.getFor(4, 2).getClass());
    }

    @Test
    public void testUnknownVersionReturnsNull() {
        Assert.assertNull((String)"Should return nothing on unknwon version", (Object)this.resolver.getFor(-1, -1));
    }

    @Test(expected=NullPointerException.class)
    public void testNonBootstrappedDoesNotReturn() {
        this.resolver.instantiate("", 0, null);
    }

    @Test
    public void testUnknownVersionLeavesPreviousInPlace() {
        this.resolver.getDefault();
        MasterClient currentClient = this.resolver.instantiate("", 0, null);
        Class<?> previousClass = currentClient.getClass();
        Assert.assertNull((Object)this.resolver.getFor(-1, -1));
        Assert.assertEquals((String)"class was not the same after getting unknown protocol", previousClass, currentClient.getClass());
        currentClient.shutdown();
    }

    @Test
    public void testAskedVersionSticks() {
        this.resolver.getFor(2, 2);
        MasterClient currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 2", MasterClient153.class, currentClient.getClass());
        currentClient.shutdown();
        this.resolver.getFor(3, 2);
        currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 3", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
        this.resolver.getFor(4, 2);
        currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient18.class, currentClient.getClass());
        currentClient.shutdown();
    }

    @Test
    public void testDowngradesArePossibleIfNotLocked() {
        this.resolver.getFor(4, 2);
        MasterClient currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient18.class, currentClient.getClass());
        currentClient.shutdown();
        this.resolver.getFor(3, 2);
        currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
        this.resolver.getFor(2, 2);
        currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient153.class, currentClient.getClass());
        currentClient.shutdown();
    }

    @Test
    public void testDowngradesArePossibleUntilLocked() {
        this.resolver.getFor(4, 2);
        MasterClient currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient18.class, currentClient.getClass());
        currentClient.shutdown();
        this.resolver.getFor(3, 2);
        currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
        this.resolver.enableDowngradeBarrier();
        this.resolver.getFor(2, 2);
        currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
    }

    @Test
    public void downgradeDoesNotHappenWhenLocked() {
        this.resolver.getFor(3, 2);
        this.resolver.enableDowngradeBarrier();
        this.resolver.getFor(2, 2);
        MasterClient currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"locking should not allow downgrade", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
    }

    @Test
    public void lockingShouldNotPreventBootstrapping() {
        this.resolver.enableDowngradeBarrier();
        this.resolver.getFor(3, 2);
        MasterClient currentClient = this.resolver.instantiate("", 0, null);
        Assert.assertEquals(MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
        currentClient = this.resolver.instantiate("", 0, null);
        this.resolver.getFor(2, 2);
        Assert.assertEquals((String)"locking should not allow downgrade", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
    }
}

