/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.EnterpriseGraphDatabaseFactory;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.zookeeper.NeoStoreUtil;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestClusterNames {
    private LocalhostZooKeeperCluster zoo;

    @Before
    public void up() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
    }

    @Test
    public void makeSureStoreIdInStoreMatchesZKData() throws Exception {
        HighlyAvailableGraphDatabase db0 = this.db(0, ConfigurationDefaults.getDefault((GraphDatabaseSetting)HaSettings.cluster_name, HaSettings.class), 6361);
        HighlyAvailableGraphDatabase db1 = this.db(1, ConfigurationDefaults.getDefault((GraphDatabaseSetting)HaSettings.cluster_name, HaSettings.class), 6362);
        this.awaitStarted((GraphDatabaseService)db0);
        this.awaitStarted((GraphDatabaseService)db1);
        db1.shutdown();
        db0.shutdown();
        ZooKeeperClusterClient cm = new ZooKeeperClusterClient(this.zoo.getConnectionString());
        cm.waitForSyncConnected();
        StoreId zkStoreId = StoreId.deserialize((byte[])cm.getZooKeeper(false).getData("/" + ConfigurationDefaults.getDefault((GraphDatabaseSetting)HaSettings.cluster_name, HaSettings.class), false, null));
        StoreId storeId = new NeoStoreUtil(db0.getStoreDir()).asStoreId();
        Assert.assertEquals((Object)storeId, (Object)zkStoreId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void makeSureMultipleHaClustersCanLiveInTheSameZKCluster() throws Exception {
        HighlyAvailableGraphDatabase db0Cluster1 = null;
        HighlyAvailableGraphDatabase db1Cluster1 = null;
        HighlyAvailableGraphDatabase db0Cluster2 = null;
        HighlyAvailableGraphDatabase db1Cluster2 = null;
        try {
            String cluster1Name = "cluster_1";
            db0Cluster1 = this.db(0, cluster1Name, 6361);
            db1Cluster1 = this.db(1, cluster1Name, 6362);
            this.awaitStarted((GraphDatabaseService)db0Cluster1);
            this.awaitStarted((GraphDatabaseService)db1Cluster1);
            String cluster2Name = "cluster.2";
            db0Cluster2 = this.db(0, cluster2Name, 6363);
            db1Cluster2 = this.db(1, cluster2Name, 6364);
            this.awaitStarted((GraphDatabaseService)db0Cluster2);
            this.awaitStarted((GraphDatabaseService)db1Cluster2);
            String cluster1PropertyName = "c1";
            this.setRefNodeName(db1Cluster1, cluster1PropertyName);
            this.pullUpdates(db0Cluster1, db1Cluster1, db0Cluster2, db1Cluster2);
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db0Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db1Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertNull((Object)db0Cluster2.getReferenceNode().getProperty("name", null));
            Assert.assertNull((Object)db1Cluster2.getReferenceNode().getProperty("name", null));
            String cluster2PropertyName = "c2";
            this.setRefNodeName(db1Cluster2, cluster2PropertyName);
            this.pullUpdates(db0Cluster1, db1Cluster1, db0Cluster2, db1Cluster2);
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db0Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db1Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db0Cluster2.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db1Cluster2.getReferenceNode().getProperty("name"));
            db0Cluster1.shutdown();
            this.pullUpdates(db1Cluster1);
            this.setRefNodeName(db1Cluster1, cluster1PropertyName);
            Assert.assertTrue((boolean)db1Cluster1.isMaster());
            db0Cluster1 = this.db(0, cluster1Name, 6361);
            this.pullUpdates(db0Cluster1, db1Cluster1);
            db1Cluster2.shutdown();
            this.pullUpdates(db0Cluster2);
            db1Cluster2 = this.db(1, cluster2Name, 6364);
            this.pullUpdates(db0Cluster2, db1Cluster2);
            cluster1PropertyName = "new c1";
            this.setRefNodeName(db1Cluster1, cluster1PropertyName);
            this.pullUpdates(db0Cluster1, db1Cluster1, db0Cluster2, db1Cluster2);
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db0Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db1Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db0Cluster2.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db1Cluster2.getReferenceNode().getProperty("name"));
            cluster2PropertyName = "new new c2";
            this.setRefNodeName(db1Cluster2, cluster2PropertyName);
            this.pullUpdates(db0Cluster1, db1Cluster1, db0Cluster2, db1Cluster2);
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db0Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db1Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db0Cluster2.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db1Cluster2.getReferenceNode().getProperty("name"));
            db0Cluster1.shutdown();
            db0Cluster1 = null;
            db1Cluster1.shutdown();
            db1Cluster1 = null;
            db0Cluster2.shutdown();
            db0Cluster2 = null;
            db1Cluster2.shutdown();
            db1Cluster2 = null;
        }
        catch (Throwable throwable) {
            this.safelyShutdownDbs(db0Cluster1, db1Cluster1, db1Cluster1, db1Cluster2);
            throw throwable;
        }
        this.safelyShutdownDbs(db0Cluster1, db1Cluster1, db1Cluster1, db1Cluster2);
    }

    private void safelyShutdownDbs(HighlyAvailableGraphDatabase ... dbs) {
        for (HighlyAvailableGraphDatabase db : dbs) {
            try {
                if (db == null) continue;
                db.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void pullUpdates(HighlyAvailableGraphDatabase ... dbs) {
        for (HighlyAvailableGraphDatabase db : dbs) {
            this.pullUpdatesWithRetry(db);
        }
    }

    private void pullUpdatesWithRetry(HighlyAvailableGraphDatabase db) {
        try {
            db.pullUpdates();
        }
        catch (RuntimeException e) {
            db.pullUpdates();
        }
    }

    private void setRefNodeName(HighlyAvailableGraphDatabase db, String name) {
        Transaction tx = db.beginTx();
        db.getReferenceNode().setProperty("name", (Object)name);
        tx.success();
        tx.finish();
    }

    private HighlyAvailableGraphDatabase db(int serverId, String clusterName, int serverPort) {
        TargetDirectory dir = TargetDirectory.forTest(this.getClass());
        return (HighlyAvailableGraphDatabase)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(dir.directory(clusterName + "-" + serverId, true).getAbsolutePath()).setConfig((Setting)HaSettings.server_id, String.valueOf(serverId)).setConfig((Setting)HaSettings.coordinators, this.zoo.getConnectionString()).setConfig((Setting)HaSettings.cluster_name, clusterName).setConfig((Setting)HaSettings.server, "localhost:" + serverPort).setConfig((Setting)HaSettings.read_timeout, "5").newGraphDatabase();
    }

    private void awaitStarted(GraphDatabaseService db) {
        while (true) {
            try {
                db.getReferenceNode();
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

