/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.netty.channel.Channel;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Server;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.kernel.ha.HaRequestType18;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.UnableToResumeTransactionException;
import org.neo4j.kernel.impl.util.StringLogger;

public class MasterServer
extends Server<Master, Void> {
    public static final int FRAME_LENGTH = 0x1000000;

    public MasterServer(Master requestTarget, int port, StringLogger logger, int maxConcurrentTransactions, int oldChannelThreshold, TxChecksumVerifier txVerifier, int chunkSize) {
        super((Object)requestTarget, port, logger, 0x1000000, (byte)4, maxConcurrentTransactions, oldChannelThreshold, txVerifier, chunkSize);
    }

    protected RequestType<Master> getRequestContext(byte id) {
        return HaRequestType18.values()[id];
    }

    protected void finishOffChannel(Channel channel, RequestContext context) {
        ((Master)this.getRequestTarget()).finishTransaction(context, false);
    }

    public void shutdown() {
        ((Master)this.getRequestTarget()).shutdown();
        super.shutdown();
    }

    protected boolean shouldLogFailureToFinishOffChannel(Throwable failure) {
        return !(failure instanceof UnableToResumeTransactionException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Collection<RequestContext>> getSlaveInformation() {
        Map channels;
        HashSet<Integer> machineIds = new HashSet<Integer>();
        Map map = channels = this.getConnectedSlaveChannels();
        synchronized (map) {
            for (RequestContext context : channels.values()) {
                machineIds.add(context.machineId());
            }
        }
        Map<Integer, Collection<RequestContext>> ongoingTransactions = ((MasterImpl)this.getRequestTarget()).getOngoingTransactions();
        for (Integer machineId : machineIds) {
            if (ongoingTransactions.containsKey(machineId)) continue;
            ongoingTransactions.put(machineId, Collections.emptyList());
        }
        return new TreeMap<Integer, Collection<RequestContext>>(ongoingTransactions);
    }
}

