/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestSlaveOnlyCluster {
    private LocalhostZooKeeperCluster zoo;
    private HighlyAvailableGraphDatabase master;
    private final HighlyAvailableGraphDatabase[] slaves = new HighlyAvailableGraphDatabase[2];
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @Before
    public void doBefore() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
        this.master = new HighlyAvailableGraphDatabase(this.dir.directory("master", true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "0", HaSettings.server.name(), "localhost:6666", HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms"}));
        for (int i = 0; i < this.slaves.length; ++i) {
            this.slaves[i] = new HighlyAvailableGraphDatabase(this.dir.directory("" + i + 1, true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "" + (i + 1), HaSettings.server.name(), "localhost:" + (6667 + i), HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms", HaSettings.slave_coordinator_update_mode.name(), "none"}));
        }
    }

    @After
    public void doAfter() throws Exception {
        for (HighlyAvailableGraphDatabase db : this.slaves) {
            if (db == null) continue;
            db.shutdown();
        }
        this.master.shutdown();
    }

    @Test
    public void testMasterElectionAfterMasterRecoversInSlaveOnlyCluster() throws Exception {
        this.master.shutdown();
        Thread.sleep(1000L);
        this.master = new HighlyAvailableGraphDatabase(this.dir.directory("master", false).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "0", HaSettings.server.name(), "localhost:6666", HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms"}));
        while (!this.master.isMaster()) {
        }
        while (((Machine)this.slaves[0].getBroker().getMaster().other()).getMachineId() == -1) {
        }
        Assert.assertEquals((long)0L, (long)((Machine)this.slaves[0].getBroker().getMaster().other()).getMachineId());
        while (((Machine)this.slaves[1].getBroker().getMaster().other()).getMachineId() == -1) {
        }
        Assert.assertEquals((long)0L, (long)((Machine)this.slaves[1].getBroker().getMaster().other()).getMachineId());
        Transaction tx = this.slaves[0].beginTx();
        this.slaves[0].createNode();
        tx.success();
        tx.finish();
    }
}

