/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.DatabaseNotRunningException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.MasterGraphDatabase;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestInternalShutdownBlocksRequests {
    private static LocalhostZooKeeperCluster zoo;
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @BeforeClass
    public static void startZoo() throws Exception {
        zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
    }

    @Test
    public void shouldBlockEvenIfInternalDatabaseIsInTheMiddleOfShuttingDown() throws Exception {
        final HighlyAvailableGraphDatabase db = this.start(this.dir.directory("master", true).getAbsolutePath(), 1, zoo.getConnectionString());
        LifeSupport masterDbLife = ((MasterGraphDatabase)db.getDependencyResolver().resolveDependency(MasterGraphDatabase.class)).life;
        masterDbLife.addLifecycleListener(new LifecycleListener(){

            public void notifyStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
                if (instance instanceof XaDataSourceManager && to == LifecycleStatus.SHUTDOWN) {
                    try {
                        db.getNodeById(0L);
                    }
                    catch (DatabaseNotRunningException e) {
                        return;
                    }
                    Assert.fail((String)"Expected db.getNodeById() to throw exception, since the database is shut down.");
                }
            }
        });
        db.internalShutdown(false);
    }

    private HighlyAvailableGraphDatabase start(String storeDir, int i, String zkConnectString) {
        return new HighlyAvailableGraphDatabase(storeDir, MapUtil.stringMap((String[])new String[]{"ha.server_id", "" + i, "ha.server", "localhost:" + (6666 + i), "ha.coordinators", zkConnectString, "ha.pull_interval", "0ms", HaSettings.read_timeout.name(), "5"}));
    }
}

