/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestIndexReuse {
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());
    private LocalhostZooKeeperCluster zoo;
    private HighlyAvailableGraphDatabase master;
    private HighlyAvailableGraphDatabase slave;

    @Test
    public void testIndexCanBeReusedAfterInternalRestart() throws Exception {
        String indexName = "indexTEST";
        String key = "testkey";
        String value = "datest";
        IndexManager indexManager = this.slave.index();
        Index nodeIndex = indexManager.forNodes(indexName);
        Node node = this.createIndexedNode(this.slave, (Index<Node>)nodeIndex, key, value);
        this.switchMaster();
        junit.framework.Assert.assertTrue((boolean)indexManager.existsForNodes(indexName));
        Assert.assertNotNull((Object)indexManager.forNodes("new index"));
        junit.framework.Assert.assertEquals((Object)node, (Object)nodeIndex.get(key, (Object)value).next());
    }

    @Before
    public void before() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
        this.master = new HighlyAvailableGraphDatabase(this.dir.directory("master", true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "0", HaSettings.server.name(), "localhost:6666", HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms", HaSettings.tx_push_strategy.name(), "fixed", HaSettings.tx_push_factor.name(), "1"}));
        this.createNode(this.master);
        Thread.sleep(5000L);
        this.slave = new HighlyAvailableGraphDatabase(this.dir.directory("slave", true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "1", HaSettings.server.name(), "localhost:6667", HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms", HaSettings.tx_push_strategy.name(), "fixed", HaSettings.tx_push_factor.name(), "1"}));
    }

    @After
    public void after() throws Exception {
        if (this.slave != null) {
            this.slave.shutdown();
        }
        if (this.master != null) {
            this.master.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createIndexedNode(HighlyAvailableGraphDatabase db, Index<Node> nodeIndex, String key, Object value) {
        Transaction tx = db.beginTx();
        Node node = null;
        try {
            node = db.createNode();
            nodeIndex.add((PropertyContainer)node, key, value);
            tx.success();
        }
        finally {
            tx.finish();
        }
        return node;
    }

    private void switchMaster() throws InterruptedException {
        this.master.shutdown();
        this.master = null;
        int count = 0;
        boolean success = false;
        do {
            try {
                this.createNode(this.slave);
                success = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(1000L);
            }
        } while (!success && ++count < 10);
        junit.framework.Assert.assertTrue((count < 10 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNode(HighlyAvailableGraphDatabase db) {
        Transaction masterTx = db.beginTx();
        try {
            db.createNode();
            masterTx.success();
        }
        finally {
            masterTx.finish();
        }
    }
}

