/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionStream;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterTxIdGenerator;
import org.neo4j.kernel.ha.Slave;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.ha.SlavePriorities;
import org.neo4j.kernel.ha.SlavePriority;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;

public class TestMasterCommittingAtSlave {
    FakeSlave[] slaves;
    XaDataSource dataSource;
    Broker broker;
    FakeStringLogger log;

    @Test
    public void commitSuccessfullyToTheFirstOne() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(3, 1, SlavePriorities.givenOrder(), new boolean[0]);
        generator.committed(this.dataSource, 0, 2L, null);
        this.assertCalls(this.slaves[0], 2L);
        this.assertNoFailureLogs();
    }

    @Test
    public void commitACoupleOfTransactionsSuccessfully() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(3, 1, SlavePriorities.givenOrder(), new boolean[0]);
        generator.committed(this.dataSource, 0, 2L, null);
        generator.committed(this.dataSource, 0, 3L, null);
        generator.committed(this.dataSource, 0, 4L, null);
        this.assertCalls(this.slaves[0], 2L, 3L, 4L);
        this.assertNoFailureLogs();
    }

    @Test
    public void commitFailureAtFirstOneShouldMoveOnToNext() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(3, 1, SlavePriorities.givenOrder(), true);
        generator.committed(this.dataSource, 0, 2L, null);
        this.assertCalls(this.slaves[0], new long[0]);
        this.assertCalls(this.slaves[1], 2L);
        this.assertNoFailureLogs();
    }

    @Test
    public void commitSuccessfullyAtThreeSlaves() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(5, 3, SlavePriorities.givenOrder(), new boolean[0]);
        generator.committed(this.dataSource, 0, 2L, null);
        generator.committed(this.dataSource, 0, 3L, Integer.valueOf(1));
        generator.committed(this.dataSource, 0, 4L, Integer.valueOf(3));
        this.assertCalls(this.slaves[0], 2L, 3L, 4L);
        this.assertCalls(this.slaves[1], 2L, 4L);
        this.assertCalls(this.slaves[2], 2L, 3L);
        this.assertCalls(this.slaves[3], new long[0]);
        this.assertCalls(this.slaves[4], new long[0]);
        this.assertNoFailureLogs();
    }

    @Test
    public void commitSuccessfullyOnSomeOfThreeSlaves() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(5, 3, SlavePriorities.givenOrder(), false, true, true);
        generator.committed(this.dataSource, 0, 2L, null);
        this.assertCalls(this.slaves[0], 2L);
        this.assertCalls(this.slaves[3], 2L);
        this.assertCalls(this.slaves[4], 2L);
        this.assertNoFailureLogs();
    }

    @Test
    public void roundRobinSingleSlave() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(3, 1, SlavePriorities.roundRobin(), new boolean[0]);
        for (long tx = 2L; tx <= 6L; ++tx) {
            generator.committed(this.dataSource, 0, tx, null);
        }
        this.assertCalls(this.slaves[0], 2L, 5L);
        this.assertCalls(this.slaves[1], 3L, 6L);
        this.assertCalls(this.slaves[2], 4L);
        this.assertNoFailureLogs();
    }

    @Test
    public void roundRobinSomeFailing() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(4, 2, SlavePriorities.roundRobin(), false, true);
        for (long tx = 2L; tx <= 6L; ++tx) {
            generator.committed(this.dataSource, 0, tx, null);
        }
        this.assertCalls(this.slaves[0], 2L, 5L, 6L);
        this.assertCalls(this.slaves[2], 2L, 3L, 4L, 6L);
        this.assertCalls(this.slaves[3], 3L, 4L, 5L);
        this.assertNoFailureLogs();
    }

    @Test
    public void notEnoughSlavesSuccessful() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(3, 2, SlavePriorities.givenOrder(), true, true);
        generator.committed(this.dataSource, 0, 2L, null);
        this.assertCalls(this.slaves[2], 2L);
        this.assertFailureLogs();
    }

    @Test
    public void testFixedPriorityStrategy() {
        SlavePriority fixed = SlavePriorities.fixed();
        Slave[] slaves = new Slave[]{new FakeSlave(false, 55), new FakeSlave(false, 101), new FakeSlave(false, 66)};
        Iterator sortedSlaves = fixed.prioritize(slaves);
        Assert.assertEquals((Object)slaves[1], sortedSlaves.next());
        Assert.assertEquals((Object)slaves[2], sortedSlaves.next());
        Assert.assertEquals((Object)slaves[0], sortedSlaves.next());
        junit.framework.Assert.assertTrue((!sortedSlaves.hasNext() ? 1 : 0) != 0);
    }

    private void assertNoFailureLogs() {
        junit.framework.Assert.assertFalse((String)("Errors:" + this.log.errors.toString()), (boolean)this.log.anyMessageLogged);
    }

    private void assertFailureLogs() {
        junit.framework.Assert.assertTrue((boolean)this.log.anyMessageLogged);
    }

    private void assertCalls(FakeSlave slave, long ... txs) {
        for (long tx : txs) {
            Long slaveTx = slave.popCalledTx();
            junit.framework.Assert.assertNotNull((Object)slaveTx);
            Assert.assertEquals((Object)tx, (Object)slaveTx);
        }
        junit.framework.Assert.assertFalse((boolean)slave.moreTxs());
    }

    private MasterTxIdGenerator newGenerator(int slaveCount, int replication, SlavePriority priority, boolean ... failingSlaves) throws Exception {
        this.slaves = this.instantiateSlaves(slaveCount, failingSlaves);
        this.dataSource = new FakeDataSource();
        this.broker = new FakeBroker(this.slaves);
        this.log = new FakeStringLogger();
        MasterTxIdGenerator result = new MasterTxIdGenerator(this.broker, replication, priority, (StringLogger)this.log);
        try {
            result.init();
            result.start();
        }
        catch (Throwable e) {
            throw Exceptions.launderedException((Throwable)e);
        }
        return result;
    }

    private FakeSlave[] instantiateSlaves(int count, boolean[] failingSlaves) {
        ArrayList<FakeSlave> slaves = new ArrayList<FakeSlave>();
        for (int i = 0; i < count; ++i) {
            slaves.add(new FakeSlave(i < failingSlaves.length ? failingSlaves[i] : false, i));
        }
        return slaves.toArray(new FakeSlave[slaves.size()]);
    }

    private static class FakeStringLogger
    extends StringLogger {
        private volatile boolean anyMessageLogged;
        private StringBuilder errors = new StringBuilder();

        private FakeStringLogger() {
        }

        public void logLongMessage(String msg, Visitor<StringLogger.LineLogger> source, boolean flush) {
            this.addError(msg);
        }

        private void addError(String msg) {
            this.anyMessageLogged = true;
            this.errors.append(this.errors.length() > 0 ? "," : "").append(msg);
        }

        public void logMessage(String msg, boolean flush) {
            this.addError(msg);
        }

        public void logMessage(String msg, Throwable cause, boolean flush) {
            this.addError(msg);
        }

        public void addRotationListener(Runnable listener) {
        }

        public void flush() {
        }

        public void close() {
        }

        protected void logLine(String line) {
            this.addError(line);
        }
    }

    private static class FakeSlave
    implements Slave {
        private volatile Queue<Long> calledWithTxId = new LinkedList<Long>();
        private final boolean failing;
        private final int serverId;

        FakeSlave(boolean failing, int serverId) {
            this.failing = failing;
            this.serverId = serverId;
        }

        public Response<Void> pullUpdates(String resource, long txId) {
            if (this.failing) {
                throw new RuntimeException("Told to fail");
            }
            this.calledWithTxId.add(txId);
            return new Response(null, new StoreId(), TransactionStream.EMPTY, ResourceReleaser.NO_OP);
        }

        Long popCalledTx() {
            return this.calledWithTxId.poll();
        }

        boolean moreTxs() {
            return !this.calledWithTxId.isEmpty();
        }

        public int getServerId() {
            return this.serverId;
        }

        public String toString() {
            return "FakeSlave[" + this.serverId + "]";
        }
    }

    private static class FakeBroker
    extends AbstractBroker {
        private final Slave[] slaves;

        FakeBroker(Slave[] slaves) {
            super(null);
            this.slaves = slaves;
        }

        public int getMyMachineId() {
            return 0;
        }

        public Slave[] getSlaves() {
            return this.slaves;
        }

        public Pair<Master, Machine> getMaster() {
            throw new UnsupportedOperationException();
        }

        public Pair<Master, Machine> getMasterReally(boolean allowChange) {
            throw new UnsupportedOperationException();
        }

        public boolean iAmMaster() {
            throw new UnsupportedOperationException();
        }

        public Object instantiateMasterServer(GraphDatabaseAPI graphDb) {
            throw new UnsupportedOperationException();
        }

        public Object instantiateSlaveServer(GraphDatabaseAPI graphDb, SlaveDatabaseOperations ops) {
            throw new UnsupportedOperationException();
        }
    }

    private static class FakeDataSource
    extends XaDataSource {
        private static final byte[] BRANCH = new byte[]{0, 1, 2};
        private static final String NAME = "fake";
        private final String dir = TargetDirectory.forTest(((Object)((Object)this)).getClass()).graphDbDir(true).getAbsolutePath();

        FakeDataSource() {
            super(BRANCH, NAME);
        }

        public XaConnection getXaConnection() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }

        public LogExtractor getLogExtractor(long startTxId, long endTxIdHint) throws IOException {
            return LogExtractor.from((String)this.dir, (long)startTxId);
        }
    }
}

