/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestTxPush {
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());
    private LocalhostZooKeeperCluster zoo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterCapableIsAheadOfSlaveOnlyRegardlessOfPriority() throws Exception {
        HighlyAvailableGraphDatabase master = null;
        HighlyAvailableGraphDatabase slave1 = null;
        HighlyAvailableGraphDatabase slave2 = null;
        try {
            this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
            master = new HighlyAvailableGraphDatabase(this.dir.directory("master", true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "0", HaSettings.server.name(), "localhost:6666", HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms", HaSettings.tx_push_strategy.name(), "fixed", HaSettings.tx_push_factor.name(), "1"}));
            slave1 = new HighlyAvailableGraphDatabase(this.dir.directory("slave1", true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "1", HaSettings.server.name(), "localhost:6667", HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms", HaSettings.slave_coordinator_update_mode.name(), "none"}));
            slave2 = new HighlyAvailableGraphDatabase(this.dir.directory("slave2", true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "2", HaSettings.server.name(), "localhost:6668", HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms"}));
            Transaction tx = master.beginTx();
            Node node = master.createNode();
            long nodeId = node.getId();
            node.setProperty("foo", (Object)"bar");
            tx.success();
            tx.finish();
            try {
                slave1.getNodeById(nodeId);
                Assert.fail((String)"It shouldn't be in the slave only instance");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            Assert.assertEquals((Object)"bar", (Object)slave2.getNodeById(nodeId).getProperty("foo"));
        }
        finally {
            if (slave2 != null) {
                slave2.shutdown();
            }
            if (slave1 != null) {
                slave1.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlaveOnlyWillNotGetPushedAtToMeetQuota() throws Exception {
        HighlyAvailableGraphDatabase master = null;
        HighlyAvailableGraphDatabase slave1 = null;
        HighlyAvailableGraphDatabase slave2 = null;
        try {
            this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
            master = new HighlyAvailableGraphDatabase(this.dir.directory("master", true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "0", HaSettings.server.name(), "localhost:6666", HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms", HaSettings.tx_push_strategy.name(), "fixed", HaSettings.tx_push_factor.name(), "2"}));
            slave1 = new HighlyAvailableGraphDatabase(this.dir.directory("slave1", true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "1", HaSettings.server.name(), "localhost:6667", HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms", HaSettings.slave_coordinator_update_mode.name(), "none"}));
            slave2 = new HighlyAvailableGraphDatabase(this.dir.directory("slave2", true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "2", HaSettings.server.name(), "localhost:6668", HaSettings.coordinators.name(), this.zoo.getConnectionString(), HaSettings.pull_interval.name(), "0ms"}));
            Transaction tx = master.beginTx();
            Node node = master.createNode();
            long nodeId = node.getId();
            node.setProperty("foo", (Object)"bar");
            tx.success();
            tx.finish();
            try {
                slave1.getNodeById(nodeId);
                Assert.fail((String)"It shouldn't be in the slave only instance");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            Assert.assertEquals((Object)"bar", (Object)slave2.getNodeById(nodeId).getProperty("foo"));
        }
        finally {
            if (slave2 != null) {
                slave2.shutdown();
            }
            if (slave1 != null) {
                slave1.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }
}

