/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.TxExtractor;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClientFactory;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.NoMasterException;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperMachine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractZooKeeperManager {
    protected static final String HA_SERVERS_CHILD = "ha-servers";
    protected static final String FLUSH_REQUESTED_CHILD = "flush-requested";
    protected static final String COMPATIBILITY_CHILD = "compatibility-1.8";
    protected static final int STOP_FLUSHING = -6;
    private final String servers;
    private final Map<Integer, Machine> haServersCache = new ConcurrentHashMap<Integer, Machine>();
    protected volatile Pair<Master, Machine> cachedMaster = NO_MASTER_MACHINE_PAIR;
    protected final StringLogger msgLog;
    private final long sessionTimeout;
    private final MasterClientFactory masterClientFactory;
    protected static final Master NO_MASTER = new Master(){

        @Override
        public void shutdown() {
        }

        @Override
        public Response<Void> pullUpdates(RequestContext context) {
            throw this.noMasterException();
        }

        private ComException noMasterException() {
            return new NoMasterException();
        }

        @Override
        public Response<Void> initializeTx(RequestContext context) {
            throw this.noMasterException();
        }

        @Override
        public Response<Pair<Integer, Long>> getMasterIdForCommittedTx(long txId, StoreId myStoreId) {
            throw this.noMasterException();
        }

        @Override
        public Response<Void> finishTransaction(RequestContext context, boolean success) {
            throw this.noMasterException();
        }

        @Override
        public Response<Integer> createRelationshipType(RequestContext context, String name) {
            throw this.noMasterException();
        }

        @Override
        public Response<Void> copyStore(RequestContext context, StoreWriter writer) {
            throw this.noMasterException();
        }

        @Override
        public Response<Void> copyTransactions(RequestContext context, String dsName, long startTxId, long endTxId) {
            throw this.noMasterException();
        }

        @Override
        public Response<Long> commitSingleResourceTransaction(RequestContext context, String resource, TxExtractor txGetter) {
            throw this.noMasterException();
        }

        @Override
        public Response<IdAllocation> allocateIds(IdType idType) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireRelationshipWriteLock(RequestContext context, long ... relationships) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireRelationshipReadLock(RequestContext context, long ... relationships) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireNodeWriteLock(RequestContext context, long ... nodes) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireNodeReadLock(RequestContext context, long ... nodes) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireGraphWriteLock(RequestContext context) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireGraphReadLock(RequestContext context) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireIndexReadLock(RequestContext context, String index, String key) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireIndexWriteLock(RequestContext context, String index, String key) {
            throw this.noMasterException();
        }

        @Override
        public Response<Void> pushTransaction(RequestContext context, String resourceName, long tx) {
            throw this.noMasterException();
        }

        public String toString() {
            return "NO_MASTER";
        }
    };
    public static final Pair<Master, Machine> NO_MASTER_MACHINE_PAIR = Pair.of((Object)NO_MASTER, (Object)ZooKeeperMachine.NO_MACHINE);

    public AbstractZooKeeperManager(String servers, StringLogger msgLog, int sessionTimeout, MasterClientFactory clientFactory) {
        assert (msgLog != null);
        this.servers = servers;
        this.msgLog = msgLog;
        this.sessionTimeout = sessionTimeout;
        this.masterClientFactory = clientFactory;
    }

    protected String asRootPath(StoreId storeId) {
        return "/" + storeId.getCreationTime() + "_" + storeId.getRandomId();
    }

    protected String getSequenceNr() {
        return "-1";
    }

    protected StoreId getClusterStoreId(ZooKeeper keeper, String clusterName) {
        try {
            byte[] child = keeper.getData("/" + clusterName, false, null);
            return StoreId.deserialize((byte[])child);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE) {
                return null;
            }
            throw new ZooKeeperException("Error getting store id", e);
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    protected int getSessionTimeout() {
        return (int)this.sessionTimeout;
    }

    public abstract ZooKeeper getZooKeeper(boolean var1);

    public abstract String getRoot();

    protected Pair<Integer, Integer> parseChild(String child) {
        int index = child.indexOf(95);
        if (index == -1) {
            return null;
        }
        int id = Integer.parseInt(child.substring(0, index));
        int seq = Integer.parseInt(child.substring(index + 1));
        return Pair.of((Object)id, (Object)seq);
    }

    protected Pair<Long, Integer> readDataRepresentingInstance(String path) throws InterruptedException, KeeperException {
        byte[] data = this.getZooKeeper(false).getData(path, false, null);
        ByteBuffer buf = ByteBuffer.wrap(data);
        return Pair.of((Object)buf.getLong(), (Object)buf.getInt());
    }

    protected void invalidateMaster() {
        if (this.cachedMaster != null) {
            Master client = (Master)this.cachedMaster.first();
            if (client != null) {
                client.shutdown();
            }
            this.cachedMaster = NO_MASTER_MACHINE_PAIR;
        }
    }

    protected Pair<Master, Machine> getMasterFromZooKeeper(boolean wait, boolean allowChange) {
        return this.getMasterFromZooKeeper(wait, WaitMode.SESSION, allowChange);
    }

    protected Pair<Master, Machine> bootstrap() {
        return this.getMasterFromZooKeeper(true, WaitMode.STARTUP, true);
    }

    private Pair<Master, Machine> getMasterFromZooKeeper(boolean wait, WaitMode mode, boolean allowChange) {
        ZooKeeperMachine master = this.getMasterBasedOn(this.getAllMachines(wait, mode).values());
        this.masterElectionHappened(this.cachedMaster, master);
        Master masterClient = NO_MASTER;
        if (((Machine)this.cachedMaster.other()).getMachineId() != master.getMachineId()) {
            this.invalidateMaster();
            if (!allowChange) {
                return NO_MASTER_MACHINE_PAIR;
            }
            if (master != Machine.NO_MACHINE && master.getMachineId() != this.getMyMachineId()) {
                masterClient = this.getMasterClientToMachine(master);
            }
            this.cachedMaster = Pair.of((Object)masterClient, (Object)master);
        }
        return this.cachedMaster;
    }

    protected void masterElectionHappened(Pair<Master, Machine> previousMaster, Machine newMaster) {
    }

    protected StoreId getStoreId() {
        return null;
    }

    protected Master getMasterClientToMachine(Machine master) {
        if (master == Machine.NO_MACHINE || master.getServer() == null) {
            return NO_MASTER;
        }
        return this.masterClientFactory.instantiate((String)master.getServer().first(), (Integer)master.getServer().other(), this.getStoreId());
    }

    protected abstract int getMyMachineId();

    public Pair<Master, Machine> getCachedMaster() {
        return this.cachedMaster;
    }

    protected ZooKeeperMachine getMasterBasedOn(Collection<ZooKeeperMachine> machines) {
        Machine master = null;
        int lowestSeq = Integer.MAX_VALUE;
        long highestTxId = -1L;
        for (ZooKeeperMachine info : machines) {
            if (info.getLastCommittedTxId() == -1L || info.getLastCommittedTxId() < highestTxId || info.getLastCommittedTxId() <= highestTxId && !info.wasCommittingMaster() && (master.wasCommittingMaster() || info.getSequenceId() >= lowestSeq)) continue;
            master = info;
            lowestSeq = info.getSequenceId();
            highestTxId = info.getLastCommittedTxId();
        }
        this.log("getMaster " + (master != null ? Integer.valueOf(master.getMachineId()) : "none") + " based on " + machines);
        if (master != null) {
            try {
                this.getZooKeeper(false).getData(this.getRoot() + "/" + ((ZooKeeperMachine)master).getZooKeeperPath(), true, null);
            }
            catch (KeeperException e) {
                throw new ZooKeeperException("Unable to get master data while setting watch", e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Interrupted while setting watch on master.", e);
            }
            return master;
        }
        return ZooKeeperMachine.NO_MACHINE;
    }

    protected Map<Integer, ZooKeeperMachine> getAllMachines(boolean wait) {
        return this.getAllMachines(wait, WaitMode.SESSION);
    }

    protected Map<Integer, ZooKeeperMachine> getAllMachines(boolean wait, WaitMode mode) {
        Map<Integer, ZooKeeperMachine> result = null;
        while (result == null) {
            result = this.getAllMachinesInner(wait, mode);
        }
        return result;
    }

    protected Map<Integer, ZooKeeperMachine> getAllMachinesInner(boolean wait, WaitMode mode) {
        if (wait) {
            this.waitForSyncConnected(mode);
        }
        try {
            int mySequenceNumber = -1;
            try {
                mySequenceNumber = Integer.parseInt(this.getSequenceNr());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.writeFlush(this.getMyMachineId());
            long endTime = System.currentTimeMillis() + this.sessionTimeout;
            block11: do {
                Thread.sleep(100L);
                HashMap<Integer, ZooKeeperMachine> result = new HashMap<Integer, ZooKeeperMachine>();
                String root = this.getRoot();
                List children = this.getZooKeeper(true).getChildren(root, false);
                for (String child : children) {
                    Pair<Integer, Integer> parsedChild = this.parseChild(child);
                    if (parsedChild == null) continue;
                    try {
                        int id = (Integer)parsedChild.first();
                        int seq = (Integer)parsedChild.other();
                        Pair<Long, Integer> instanceData = this.readDataRepresentingInstance(root + "/" + child);
                        long lastCommittedTxId = (Long)instanceData.first();
                        int masterId = (Integer)instanceData.other();
                        if (id == this.getMyMachineId() && mySequenceNumber == -1) continue;
                        if (lastCommittedTxId == -2L) continue block11;
                        if (result.containsKey(id) && seq <= ((ZooKeeperMachine)result.get(id)).getSequenceId()) continue;
                        Machine haServer = this.getHaServer(id, wait);
                        ZooKeeperMachine toAdd = new ZooKeeperMachine(id, seq, lastCommittedTxId, masterId, haServer.getServerAsString(), haServer.getBackupPort(), "ha-servers/" + id);
                        result.put(id, toAdd);
                    }
                    catch (KeeperException inner) {
                        if (inner.code() == KeeperException.Code.NONODE) continue;
                        throw new ZooKeeperException("Unable to get master.", inner);
                    }
                }
                HashMap<Integer, ZooKeeperMachine> hashMap = result;
                return hashMap;
            } while (System.currentTimeMillis() < endTime);
            Map<Integer, ZooKeeperMachine> map = null;
            return map;
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to get master", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted.", e);
        }
        finally {
            this.writeFlush(-6);
        }
    }

    protected Machine getHaServer(int machineId, boolean wait) {
        Machine result = this.haServersCache.get(machineId);
        if (result == null) {
            result = this.readHaServer(machineId, wait);
            this.haServersCache.put(machineId, result);
        }
        return result;
    }

    protected void refreshHaServers() throws KeeperException {
        try {
            HashSet<Integer> visitedChildren = new HashSet<Integer>();
            for (String child : this.getZooKeeper(true).getChildren(this.getRoot() + "/" + HA_SERVERS_CHILD, false)) {
                int id;
                try {
                    id = this.idFromPath(child);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                this.haServersCache.put(id, this.readHaServer(id, false));
                visitedChildren.add(id);
            }
            this.haServersCache.keySet().retainAll(visitedChildren);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    protected Iterable<Machine> getHaServers() {
        return this.haServersCache.values();
    }

    protected int getNumberOfServers() {
        return this.haServersCache.size();
    }

    protected Machine readHaServer(int machineId, boolean wait) {
        if (wait) {
            this.waitForSyncConnected();
        }
        String rootPath = this.getRoot();
        String haServerPath = rootPath + "/" + HA_SERVERS_CHILD + "/" + machineId;
        try {
            byte[] serverData = this.getZooKeeper(true).getData(haServerPath, false, null);
            ByteBuffer buffer = ByteBuffer.wrap(serverData);
            int backupPort = buffer.getInt();
            byte length = buffer.get();
            char[] chars = new char[length];
            buffer.asCharBuffer().get(chars);
            String result = String.valueOf(chars);
            this.log("Read HA server:" + result + " (for machineID " + machineId + ") from zoo keeper");
            return new Machine(machineId, 0, 0L, 0, result, backupPort);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Couldn't find the HA server: " + rootPath, e);
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    private void log(String string) {
        if (this.msgLog != null) {
            this.msgLog.logMessage(string);
        }
    }

    public void shutdown() {
        try {
            this.invalidateMaster();
            this.cachedMaster = NO_MASTER_MACHINE_PAIR;
            this.getZooKeeper(false).close();
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Error closing zookeeper connection", e);
        }
    }

    public final void waitForSyncConnected() {
        this.waitForSyncConnected(WaitMode.SESSION);
    }

    abstract void waitForSyncConnected(WaitMode var1);

    public String getServers() {
        return this.servers;
    }

    protected int idFromPath(String path) {
        return Integer.parseInt(path.substring(path.lastIndexOf(47) + 1));
    }

    private void writeFlush(int toWrite) {
        String path = this.getRoot() + "/" + FLUSH_REQUESTED_CHILD;
        byte[] data = new byte[4];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.putInt(toWrite);
        boolean created = false;
        try {
            block9: {
                if (this.getZooKeeper(true).exists(path, false) == null) {
                    try {
                        this.getZooKeeper(true).create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                        created = true;
                    }
                    catch (KeeperException inner) {
                        if (inner.code() == KeeperException.Code.NODEEXISTS) break block9;
                        throw inner;
                    }
                }
            }
            if (!created) {
                int current = ByteBuffer.wrap(this.getZooKeeper(true).getData(path, false, null)).getInt();
                if (current != -6 && toWrite == -6 && current != this.getMyMachineId()) {
                    this.msgLog.logMessage("Conflicted with " + current + " on getAllMachines() - will reset but waiting a bit");
                    Thread.sleep(300L);
                }
                if (current != toWrite) {
                    this.msgLog.logMessage("Writing at flush-requested: " + toWrite);
                    this.getZooKeeper(true).setData(path, data, -1);
                }
            }
            this.getZooKeeper(true).getData(path, true, null);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to write to flush-requested", e);
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Interrupted while trying to write to flush-requested", e);
        }
    }

    private static class StartupWaitStrategy
    implements WaitStrategy {
        static final long SECONDS_TO_WAIT_BETWEEN_NOTIFICATIONS = 30L;
        private long lastNotification = 0L;
        private final StringLogger msgLog;

        public StartupWaitStrategy(StringLogger msgLog) {
            this.msgLog = msgLog;
        }

        @Override
        public boolean waitMore(long waitedSoFar) {
            long currentNotification = waitedSoFar / 30000L;
            if (currentNotification > this.lastNotification) {
                this.lastNotification = currentNotification;
                this.msgLog.logMessage("Have been waiting for " + 30L * currentNotification + " seconds for the ZooKeeper cluster to respond.");
            }
            return true;
        }
    }

    private static class SessionWaitStrategy
    implements WaitStrategy {
        private final long sessionTimeout;

        SessionWaitStrategy(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Override
        public boolean waitMore(long waitedSoFar) {
            return waitedSoFar < this.sessionTimeout;
        }
    }

    static interface WaitStrategy {
        public boolean waitMore(long var1);
    }

    static enum WaitMode {
        STARTUP{

            @Override
            public WaitStrategy getStrategy(AbstractZooKeeperManager zooClient) {
                return new StartupWaitStrategy(zooClient.msgLog);
            }
        }
        ,
        SESSION{

            @Override
            public WaitStrategy getStrategy(AbstractZooKeeperManager zooClient) {
                return new SessionWaitStrategy(zooClient.getSessionTimeout());
            }
        };


        public abstract WaitStrategy getStrategy(AbstractZooKeeperManager var1);
    }
}

