/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import junit.framework.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.ha.FakeClusterChecker;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ClusterChecker;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.ClusterClient;
import org.neo4j.kernel.ha.FakeClusterClient;
import org.neo4j.kernel.ha.FakeMasterBroker;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.TargetDirectory;

public class TestBranchedData {
    private final File dir = TargetDirectory.forTest(this.getClass()).graphDbDir(true);

    @Test
    public void migrationOfBranchedDataDirectories() throws Exception {
        long[] timestamps = new long[3];
        for (int i = 0; i < timestamps.length; ++i) {
            this.startDbAndCreateNode();
            timestamps[i] = this.moveAwayToLookLikeOldBranchedDirectory();
            Thread.sleep(1L);
        }
        HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(this.dir.getAbsolutePath(), MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "1"})){

            protected Broker createBroker() {
                return new FakeMasterBroker(this.configuration);
            }

            protected ClusterClient createClusterClient() {
                return new FakeClusterClient(this.getBroker());
            }

            protected ClusterChecker createClusterChecker() {
                return new FakeClusterChecker();
            }
        };
        db.shutdown();
        for (long timestamp : timestamps) {
            Assert.assertFalse((String)("directory branched-" + timestamp + " still exists."), (boolean)new File(this.dir, "branched-" + timestamp).exists());
            Assert.assertTrue((String)("directory " + timestamp + " is not there"), (boolean)HighlyAvailableGraphDatabase.BranchedDataPolicy.getBranchedDataDirectory((String)this.dir.getAbsolutePath(), (long)timestamp).exists());
        }
    }

    private long moveAwayToLookLikeOldBranchedDirectory() {
        long timestamp = System.currentTimeMillis();
        File branchDir = new File(this.dir, "branched-" + timestamp);
        branchDir.mkdirs();
        for (File file : this.dir.listFiles()) {
            if (file.equals("messages.log") || file.getName().startsWith("branched-")) continue;
            Assert.assertTrue((boolean)FileUtils.renameFile((File)file, (File)new File(branchDir, file.getName())));
        }
        return timestamp;
    }

    private void startDbAndCreateNode() {
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(this.dir.getAbsolutePath());
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        db.shutdown();
    }
}

