/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.EnterpriseGraphDatabaseFactory;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.zookeeper.NoMasterException;
import org.neo4j.kernel.ha.zookeeper.ZooClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperBroker;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestConfig {
    private LocalhostZooKeeperCluster zoo;
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @Before
    public void doBefore() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
    }

    @Test
    public void testZkSessionTimeout() throws Exception {
        long timeout = 80000L;
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("zkTimeout", true).getAbsolutePath()).setConfig((Setting)HaSettings.server_id, "1").setConfig((Setting)HaSettings.coordinators, this.zoo.getConnectionString()).setConfig((Setting)HaSettings.zk_session_timeout, "" + timeout).newGraphDatabase();
        ZooKeeperBroker broker = (ZooKeeperBroker)db.getBroker();
        Field f = broker.getClass().getDeclaredField("zooClient");
        f.setAccessible(true);
        ZooClient zooClient = (ZooClient)f.get(broker);
        Method m = zooClient.getClass().getSuperclass().getDeclaredMethod("getSessionTimeout", new Class[0]);
        m.setAccessible(true);
        Integer timeoutParsed = (Integer)m.invoke((Object)zooClient, new Object[0]);
        Assert.assertEquals((long)timeout, (long)timeoutParsed.intValue());
        f = db.getClass().getDeclaredField("clusterClient");
        f.setAccessible(true);
        ZooKeeperClusterClient clusterClient = (ZooKeeperClusterClient)f.get(db);
        m = clusterClient.getClass().getSuperclass().getDeclaredMethod("getSessionTimeout", new Class[0]);
        m.setAccessible(true);
        timeoutParsed = (Integer)m.invoke((Object)clusterClient, new Object[0]);
        Assert.assertEquals((long)timeout, (long)timeoutParsed.intValue());
        db.shutdown();
    }

    @Test
    public void gcrCachesGetsReusedBetweenInternalRestarts() throws Exception {
        ArrayList<HighlyAvailableGraphDatabase> dbs = new ArrayList<HighlyAvailableGraphDatabase>();
        for (int i = 0; i < 3; ++i) {
            HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("gcr" + i, true).getAbsolutePath()).setConfig((Setting)HaSettings.server_id, "" + i).setConfig((Setting)HaSettings.coordinators, this.zoo.getConnectionString()).setConfig((Setting)GraphDatabaseSettings.cache_type, "gcr").setConfig((Setting)HaSettings.server, "localhost:" + (6361 + i)).newGraphDatabase();
            dbs.add(db);
        }
        this.doTransaction((HighlyAvailableGraphDatabase)dbs.get(0));
        int master = this.getMaster(dbs);
        Map<Integer, Cache<?>> cacheObjects = this.gatherCacheObjects(dbs);
        ((HighlyAvailableGraphDatabase)dbs.get(master)).shutdown();
        int otherThanMaster = (master + 1) % dbs.size();
        this.pullUpdates((HighlyAvailableGraphDatabase)dbs.get(otherThanMaster));
        int newMaster = this.getMaster(dbs);
        Assert.assertFalse((master == newMaster ? 1 : 0) != 0);
        Cache newCache = (Cache)IteratorUtil.first((Iterable)((HighlyAvailableGraphDatabase)dbs.get(newMaster)).getNodeManager().caches());
        Assert.assertEquals((String)"Expected the cache instance from when it was slave and now when it's master to be the same", cacheObjects.get(newMaster), (Object)newCache);
        for (int i = 0; i < dbs.size(); ++i) {
            if (i == master) continue;
            ((HighlyAvailableGraphDatabase)dbs.get(i)).shutdown();
        }
    }

    @Test
    public void shouldOperateWhenChunkSizeIsSmallerThanFrameLength() throws Exception {
        this.testSimpleCommunicationWithConfiguredChunkSize("16777215");
    }

    @Test
    public void shouldOperateWhenChunkSizeIsEqualToFrameLength() throws Exception {
        this.testSimpleCommunicationWithConfiguredChunkSize("16777216");
    }

    @Test
    public void shouldNotOperateWhenChunkSizeIsLargerThanFrameLength() throws Exception {
        try {
            new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("chunk_size", true).getAbsolutePath()).setConfig((Setting)HaSettings.com_chunk_size, "16777217").setConfig((Setting)HaSettings.coordinators, this.zoo.getConnectionString()).setConfig((Setting)HaSettings.server_id, "1").newGraphDatabase();
            Assert.fail((String)"Shouldn't be able to operate with such a high chunk size");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"Chunk size 16777217 needs to be equal or less than frame length 16777216"));
        }
    }

    private void testSimpleCommunicationWithConfiguredChunkSize(String chunkSize) {
        GraphDatabaseService master = new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("chunk_size1", true).getAbsolutePath()).setConfig((Setting)HaSettings.com_chunk_size, chunkSize).setConfig((Setting)HaSettings.coordinators, this.zoo.getConnectionString()).setConfig((Setting)HaSettings.server, "localhost:6361").setConfig((Setting)HaSettings.server_id, "1").newGraphDatabase();
        GraphDatabaseService slave = new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("chunk_size2", true).getAbsolutePath()).setConfig((Setting)HaSettings.com_chunk_size, chunkSize).setConfig((Setting)HaSettings.coordinators, this.zoo.getConnectionString()).setConfig((Setting)HaSettings.server, "localhost:6362").setConfig((Setting)HaSettings.server_id, "2").newGraphDatabase();
        this.pullUpdates((HighlyAvailableGraphDatabase)slave);
        slave.shutdown();
        master.shutdown();
    }

    private void pullUpdates(HighlyAvailableGraphDatabase db) {
        try {
            db.pullUpdates();
        }
        catch (NoMasterException e) {
            db.pullUpdates();
        }
    }

    private Map<Integer, Cache<?>> gatherCacheObjects(List<HighlyAvailableGraphDatabase> dbs) {
        HashMap map = new HashMap();
        for (int i = 0; i < dbs.size(); ++i) {
            map.put(i, (Cache<?>)IteratorUtil.first((Iterable)dbs.get(i).getNodeManager().caches()));
        }
        return map;
    }

    private int getMaster(List<HighlyAvailableGraphDatabase> dbs) {
        for (int i = 0; i < dbs.size(); ++i) {
            HighlyAvailableGraphDatabase db = dbs.get(i);
            if (!db.isMaster()) continue;
            return i;
        }
        throw new IllegalStateException("No master found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransaction(HighlyAvailableGraphDatabase db) {
        Transaction tx = db.beginTx();
        try {
            db.createNode();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

