/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.test.StreamConsumer;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestPullUpdatesApplied {
    private LocalhostZooKeeperCluster zoo;
    private final HighlyAvailableGraphDatabase[] dbs = new HighlyAvailableGraphDatabase[3];
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @Before
    public void doBefore() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
        for (int i = 0; i < this.dbs.length; ++i) {
            this.dbs[i] = this.newDb(i);
        }
    }

    private HighlyAvailableGraphDatabase newDb(int i) {
        return this.newDb(i, true);
    }

    private HighlyAvailableGraphDatabase newDb(int i, boolean clear) {
        return new HighlyAvailableGraphDatabase(this.dir.directory("" + i, clear).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{"ha.server_id", "" + i, "ha.server", "localhost:" + (6666 + i), "ha.coordinators", this.zoo.getConnectionString(), "ha.pull_interval", "0ms"}));
    }

    @After
    public void doAfter() throws Exception {
        for (HighlyAvailableGraphDatabase db : this.dbs) {
            if (db == null) continue;
            db.shutdown();
        }
    }

    @Test
    public void testUpdatesAreWritenToLogBeforeBeingAppliedToStore() throws Exception {
        int master = this.getCurrentMaster();
        this.addNode(master);
        int toKill = (master + 1) % this.dbs.length;
        HighlyAvailableGraphDatabase dbToKill = this.dbs[toKill];
        dbToKill.shutdown();
        this.addNode(master);
        File targetDirectory = this.dir.directory("" + toKill, false);
        TestPullUpdatesApplied.runInOtherJvmToGetExitCode(targetDirectory.getAbsolutePath(), "" + toKill, this.zoo.getConnectionString());
        this.start(toKill, false);
        boolean hasBranchedData = new File(targetDirectory, "branched").listFiles().length > 0;
        Assert.assertFalse((boolean)hasBranchedData);
    }

    public static void main(String[] args) throws Exception {
        int i = Integer.parseInt(args[1]);
        HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(args[0], MapUtil.stringMap((String[])new String[]{"ha.server_id", "" + i, "ha.server", "localhost:" + (6666 + i), "ha.coordinators", args[2], "ha.pull_interval", "0ms"}));
        db.pullUpdates();
    }

    public static int runInOtherJvmToGetExitCode(String ... args) throws Exception {
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList("java", "-cp", System.getProperty("java.class.path"), TestPullUpdatesApplied.class.getName()));
        allArgs.addAll(Arrays.asList(args));
        Process p = Runtime.getRuntime().exec(allArgs.toArray(new String[allArgs.size()]));
        LinkedList<Thread> threads = new LinkedList<Thread>();
        TestPullUpdatesApplied.launchStreamConsumers(threads, p);
        Thread.sleep(5000L);
        p.destroy();
        for (Thread t : threads) {
            t.join();
        }
        return 0;
    }

    private static void launchStreamConsumers(List<Thread> join, Process p) {
        InputStream outStr = p.getInputStream();
        InputStream errStr = p.getErrorStream();
        Thread out = new Thread((Runnable)new StreamConsumer(outStr, (OutputStream)System.out, false));
        join.add(out);
        Thread err = new Thread((Runnable)new StreamConsumer(errStr, (OutputStream)System.err, false));
        join.add(err);
        out.start();
        err.start();
    }

    private void start(int master, boolean clear) {
        this.dbs[master] = this.newDb(master, clear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addNode(int dbId) {
        HighlyAvailableGraphDatabase db = this.dbs[dbId];
        long result = -1L;
        Transaction tx = db.beginTx();
        try {
            result = db.createNode().getId();
            tx.success();
        }
        finally {
            tx.finish();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentMaster() {
        ZooKeeperClusterClient client = new ZooKeeperClusterClient(this.zoo.getConnectionString());
        try {
            int n = client.getMaster().getMachineId();
            return n;
        }
        finally {
            client.shutdown();
        }
    }
}

