/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestInstanceJoin {
    private static LocalhostZooKeeperCluster zoo;
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());
    private HighlyAvailableGraphDatabase master;
    private HighlyAvailableGraphDatabase slave;

    @BeforeClass
    public static void startZoo() throws Exception {
        zoo = LocalhostZooKeeperCluster.singleton();
    }

    @Before
    public void cleanZoo() throws Exception {
        zoo.clearDataAndVerifyConnection();
    }

    @Test
    public void shouldAllowSlaveToJoinWithEmptyStore() throws Exception {
        this.startAndPopulateMaster();
        this.startSlave(true);
        Assert.assertThat((Object)((String)this.master.getReferenceNode().getProperty("someProperty")), (Matcher)Is.is((Object)"someValue"));
        Assert.assertThat((Object)((String)this.slave.getReferenceNode().getProperty("someProperty")), (Matcher)Is.is((Object)"someValue"));
    }

    @Test
    public void shouldAllowSlaveToJoinWithOutdatedData() throws Exception {
        this.startAndPopulateMaster();
        this.startSlave(true);
        this.slave.shutdown();
        this.updateMaster();
        this.startSlave(false);
        Assert.assertThat((Object)((String)this.master.getReferenceNode().getProperty("someProperty")), (Matcher)Is.is((Object)"AnUpdatedValue"));
        Assert.assertThat((Object)((String)this.slave.getReferenceNode().getProperty("someProperty")), (Matcher)Is.is((Object)"AnUpdatedValue"));
    }

    @Test
    public void shouldAllowSlaveToJoinWithOutdatedDataEvenWhenPeersUnavailable() throws Exception {
        this.startAndPopulateMaster();
        this.startSlave(true);
        this.slave.shutdown();
        this.updateMaster();
        Assert.assertThat((Object)((String)this.master.getReferenceNode().getProperty("someProperty")), (Matcher)Is.is((Object)"AnUpdatedValue"));
        this.master.shutdown();
        this.startSlave(false);
        Assert.assertThat((Object)((String)this.slave.getReferenceNode().getProperty("someProperty")), (Matcher)Is.is((Object)"someValue"));
    }

    @Test
    public void shouldNotAllowSlaveToJoinWithEmptyStoreWhenPeersUnavailable() throws Exception {
        this.startAndPopulateMaster();
        this.master.shutdown();
        try {
            this.startSlave(true);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"Joining an existing cluster with an empty store is not allowed."));
        }
    }

    @After
    public void shutDownInstances() throws Exception {
        try {
            if (this.slave != null) {
                this.slave.shutdown();
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            if (this.master != null) {
                this.master.shutdown();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void startAndPopulateMaster() {
        HighlyAvailableGraphDatabase master = TestInstanceJoin.start(this.dir.directory("master", true).getAbsolutePath(), 1, zoo.getConnectionString());
        Transaction tx = master.beginTx();
        master.getReferenceNode().setProperty("someProperty", (Object)"someValue");
        tx.success();
        tx.finish();
        this.master = master;
    }

    private void startSlave(boolean clean) throws InterruptedException {
        HighlyAvailableGraphDatabase slave = TestInstanceJoin.start(this.dir.directory("slave", clean).getAbsolutePath(), 2, zoo.getConnectionString());
        Thread.sleep(100L);
        this.slave = slave;
    }

    private void updateMaster() {
        Transaction tx = this.master.beginTx();
        this.master.getReferenceNode().setProperty("someProperty", (Object)"AnUpdatedValue");
        tx.success();
        tx.finish();
    }

    private static HighlyAvailableGraphDatabase start(String storeDir, int i, String zkConnectString) {
        return new HighlyAvailableGraphDatabase(storeDir, MapUtil.stringMap((String[])new String[]{"ha.server_id", "" + i, "ha.server", "localhost:" + (6666 + i), "ha.coordinators", zkConnectString, "ha.pull_interval", "10ms"}));
    }
}

